/******************************************************************************
*
* Copyright(c) 2007 - 2017 Realtek Corporation.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of version 2 of the GNU General Public License as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
* more details.
*
******************************************************************************/

/*Image2HeaderVersion: R2 1.2.1*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8822B_SUPPORT == 1)
static boolean
check_positive(
	struct PHY_DM_STRUCT *p_dm_odm,
	const u32	condition1,
	const u32	condition2,
	const u32	condition3,
	const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2, cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para = (p_dm_odm->cut_version ==  ODM_CUT_A) ? 15 : p_dm_odm->cut_version;
	u8	pkg_type_for_para = (p_dm_odm->package_type == 0) ? 15 : p_dm_odm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(p_dm_odm->support_interface & 0xF0) << 16 |
			p_dm_odm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(p_dm_odm->support_interface & 0x0F) << 8  |
			p_dm_odm->rfe_type;

	u32	driver2 = (p_dm_odm->type_glna & 0xFF) <<  0 |
			(p_dm_odm->type_gpa & 0xFF)  <<  8 |
			(p_dm_odm->type_alna & 0xFF) << 16 |
			(p_dm_odm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (p_dm_odm->type_glna & 0xFF00) >>  8 |
			(p_dm_odm->type_gpa & 0xFF00) |
			(p_dm_odm->type_alna & 0xFF00) << 8 |
			(p_dm_odm->type_apa & 0xFF00)  << 16;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("===> check_positive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("===> check_positive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("	(Platform, Interface) = (0x%X, 0x%X)\n", p_dm_odm->support_platform, p_dm_odm->support_interface));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("	(RFE, Package) = (0x%X, 0x%X)\n", p_dm_odm->rfe_type, p_dm_odm->package_type));


	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/

	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/

	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}
static boolean
check_negative(
	struct PHY_DM_STRUCT *p_dm_odm,
	const u32	condition1,
	const u32	condition2
)
{
	return true;
}

/******************************************************************************
*                           agc_tab.TXT
******************************************************************************/

u32 array_mp_8822b_agc_tab[] = {
	0x80000000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xEC240003,
		0x81C, 0xEB260003,
		0x81C, 0xEA280003,
		0x81C, 0xE92A0003,
		0x81C, 0xE82C0003,
		0x81C, 0xE72E0003,
		0x81C, 0xE6300003,
		0x81C, 0xE5320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xC1420003,
		0x81C, 0xC0440003,
		0x81C, 0xA3460003,
		0x81C, 0xA2480003,
		0x81C, 0xA14A0003,
		0x81C, 0xA04C0003,
		0x81C, 0x824E0003,
		0x81C, 0x81500003,
		0x81C, 0x80520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x445A0003,
		0x81C, 0x435C0003,
		0x81C, 0x425E0003,
		0x81C, 0x41600003,
		0x81C, 0x40620003,
		0x81C, 0x05640003,
		0x81C, 0x04660003,
		0x81C, 0x03680003,
		0x81C, 0x026A0003,
		0x81C, 0x016C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xF5000003,
		0x81C, 0xF4020003,
		0x81C, 0xF3040003,
		0x81C, 0xF2060003,
		0x81C, 0xF1080003,
		0x81C, 0xF00A0003,
		0x81C, 0xEF0C0003,
		0x81C, 0xEE0E0003,
		0x81C, 0xED100003,
		0x81C, 0xEC120003,
		0x81C, 0xEB140003,
		0x81C, 0xEA160003,
		0x81C, 0xE9180003,
		0x81C, 0xE81A0003,
		0x81C, 0xE71C0003,
		0x81C, 0xE61E0003,
		0x81C, 0xE5200003,
		0x81C, 0xE4220003,
		0x81C, 0xE3240003,
		0x81C, 0xE2260003,
		0x81C, 0xE1280003,
		0x81C, 0xE02A0003,
		0x81C, 0xC32C0003,
		0x81C, 0xC22E0003,
		0x81C, 0xC1300003,
		0x81C, 0xC0320003,
		0x81C, 0xA4340003,
		0x81C, 0xA3360003,
		0x81C, 0xA2380003,
		0x81C, 0xA13A0003,
		0x81C, 0xA03C0003,
		0x81C, 0x823E0003,
		0x81C, 0x81400003,
		0x81C, 0x80420003,
		0x81C, 0x64440003,
		0x81C, 0x63460003,
		0x81C, 0x62480003,
		0x81C, 0x614A0003,
		0x81C, 0x604C0003,
		0x81C, 0x454E0003,
		0x81C, 0x44500003,
		0x81C, 0x43520003,
		0x81C, 0x42540003,
		0x81C, 0x41560003,
		0x81C, 0x40580003,
		0x81C, 0x055A0003,
		0x81C, 0x045C0003,
		0x81C, 0x035E0003,
		0x81C, 0x02600003,
		0x81C, 0x01620003,
		0x81C, 0x00640003,
		0x81C, 0x00660003,
		0x81C, 0x00680003,
		0x81C, 0x006A0003,
		0x81C, 0x006C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFD000003,
		0x81C, 0xFC020003,
		0x81C, 0xFB040003,
		0x81C, 0xFA060003,
		0x81C, 0xF9080003,
		0x81C, 0xF80A0003,
		0x81C, 0xF70C0003,
		0x81C, 0xF60E0003,
		0x81C, 0xF5100003,
		0x81C, 0xF4120003,
		0x81C, 0xF3140003,
		0x81C, 0xF2160003,
		0x81C, 0xF1180003,
		0x81C, 0xF01A0003,
		0x81C, 0xEF1C0003,
		0x81C, 0xEE1E0003,
		0x81C, 0xED200003,
		0x81C, 0xEC220003,
		0x81C, 0xEB240003,
		0x81C, 0xEA260003,
		0x81C, 0xE9280003,
		0x81C, 0xE82A0003,
		0x81C, 0xE72C0003,
		0x81C, 0xE62E0003,
		0x81C, 0xE5300003,
		0x81C, 0xC8320003,
		0x81C, 0xC7340003,
		0x81C, 0xC6360003,
		0x81C, 0xC5380003,
		0x81C, 0xC43A0003,
		0x81C, 0xC33C0003,
		0x81C, 0xC23E0003,
		0x81C, 0xC1400003,
		0x81C, 0xC0420003,
		0x81C, 0xA5440003,
		0x81C, 0xA4460003,
		0x81C, 0xA3480003,
		0x81C, 0xA24A0003,
		0x81C, 0xA14C0003,
		0x81C, 0x834E0003,
		0x81C, 0x82500003,
		0x81C, 0x81520003,
		0x81C, 0x80540003,
		0x81C, 0x65560003,
		0x81C, 0x64580003,
		0x81C, 0x635A0003,
		0x81C, 0x625C0003,
		0x81C, 0x435E0003,
		0x81C, 0x42600003,
		0x81C, 0x41620003,
		0x81C, 0x40640003,
		0x81C, 0x06660003,
		0x81C, 0x05680003,
		0x81C, 0x046A0003,
		0x81C, 0x036C0003,
		0x81C, 0x026E0003,
		0x81C, 0x01700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFD000003,
		0x81C, 0xFC020003,
		0x81C, 0xFB040003,
		0x81C, 0xFA060003,
		0x81C, 0xF9080003,
		0x81C, 0xF80A0003,
		0x81C, 0xF70C0003,
		0x81C, 0xF60E0003,
		0x81C, 0xF5100003,
		0x81C, 0xF4120003,
		0x81C, 0xF3140003,
		0x81C, 0xF2160003,
		0x81C, 0xF1180003,
		0x81C, 0xF01A0003,
		0x81C, 0xEF1C0003,
		0x81C, 0xEE1E0003,
		0x81C, 0xED200003,
		0x81C, 0xEC220003,
		0x81C, 0xEB240003,
		0x81C, 0xEA260003,
		0x81C, 0xE9280003,
		0x81C, 0xE82A0003,
		0x81C, 0xE72C0003,
		0x81C, 0xE62E0003,
		0x81C, 0xE5300003,
		0x81C, 0xC8320003,
		0x81C, 0xC7340003,
		0x81C, 0xC6360003,
		0x81C, 0xC5380003,
		0x81C, 0xC43A0003,
		0x81C, 0xC33C0003,
		0x81C, 0xC23E0003,
		0x81C, 0xC1400003,
		0x81C, 0xC0420003,
		0x81C, 0xA5440003,
		0x81C, 0xA4460003,
		0x81C, 0xA3480003,
		0x81C, 0xA24A0003,
		0x81C, 0xA14C0003,
		0x81C, 0x834E0003,
		0x81C, 0x82500003,
		0x81C, 0x81520003,
		0x81C, 0x80540003,
		0x81C, 0x65560003,
		0x81C, 0x64580003,
		0x81C, 0x635A0003,
		0x81C, 0x625C0003,
		0x81C, 0x435E0003,
		0x81C, 0x42600003,
		0x81C, 0x41620003,
		0x81C, 0x40640003,
		0x81C, 0x06660003,
		0x81C, 0x05680003,
		0x81C, 0x046A0003,
		0x81C, 0x036C0003,
		0x81C, 0x026E0003,
		0x81C, 0x01700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xDC000003,
		0x81C, 0xDB020003,
		0x81C, 0xDA040003,
		0x81C, 0xD9060003,
		0x81C, 0xD8080003,
		0x81C, 0xD70A0003,
		0x81C, 0xD60C0003,
		0x81C, 0xD50E0003,
		0x81C, 0xD4100003,
		0x81C, 0xD3120003,
		0x81C, 0xD2140003,
		0x81C, 0xD1160003,
		0x81C, 0xD0180003,
		0x81C, 0xB41A0003,
		0x81C, 0xB31C0003,
		0x81C, 0xB21E0003,
		0x81C, 0xB1200003,
		0x81C, 0xB0220003,
		0x81C, 0xAF240003,
		0x81C, 0xAE260003,
		0x81C, 0xAD280003,
		0x81C, 0xAC2A0003,
		0x81C, 0xAB2C0003,
		0x81C, 0x8C2E0003,
		0x81C, 0x8B300003,
		0x81C, 0x8A320003,
		0x81C, 0x89340003,
		0x81C, 0x88360003,
		0x81C, 0x87380003,
		0x81C, 0x863A0003,
		0x81C, 0x853C0003,
		0x81C, 0x693E0003,
		0x81C, 0x68400003,
		0x81C, 0x67420003,
		0x81C, 0x66440003,
		0x81C, 0x65460003,
		0x81C, 0x48480003,
		0x81C, 0x474A0003,
		0x81C, 0x464C0003,
		0x81C, 0x454E0003,
		0x81C, 0x44500003,
		0x81C, 0x43520003,
		0x81C, 0x27540003,
		0x81C, 0x26560003,
		0x81C, 0x25580003,
		0x81C, 0x245A0003,
		0x81C, 0x235C0003,
		0x81C, 0x045E0003,
		0x81C, 0x03600003,
		0x81C, 0x02620003,
		0x81C, 0x01640003,
		0x81C, 0x00660003,
		0x81C, 0x00680003,
		0x81C, 0x006A0003,
		0x81C, 0x006C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFD000003,
		0x81C, 0xFC020003,
		0x81C, 0xFB040003,
		0x81C, 0xFA060003,
		0x81C, 0xF9080003,
		0x81C, 0xF80A0003,
		0x81C, 0xF70C0003,
		0x81C, 0xF60E0003,
		0x81C, 0xF5100003,
		0x81C, 0xF4120003,
		0x81C, 0xF3140003,
		0x81C, 0xF2160003,
		0x81C, 0xF1180003,
		0x81C, 0xF01A0003,
		0x81C, 0xEF1C0003,
		0x81C, 0xEE1E0003,
		0x81C, 0xED200003,
		0x81C, 0xEC220003,
		0x81C, 0xEB240003,
		0x81C, 0xEA260003,
		0x81C, 0xE9280003,
		0x81C, 0xE82A0003,
		0x81C, 0xE72C0003,
		0x81C, 0xE62E0003,
		0x81C, 0xE5300003,
		0x81C, 0xC8320003,
		0x81C, 0xC7340003,
		0x81C, 0xC6360003,
		0x81C, 0xC5380003,
		0x81C, 0xC43A0003,
		0x81C, 0xC33C0003,
		0x81C, 0xC23E0003,
		0x81C, 0xC1400003,
		0x81C, 0xC0420003,
		0x81C, 0xA5440003,
		0x81C, 0xA4460003,
		0x81C, 0xA3480003,
		0x81C, 0xA24A0003,
		0x81C, 0xA14C0003,
		0x81C, 0x834E0003,
		0x81C, 0x82500003,
		0x81C, 0x81520003,
		0x81C, 0x80540003,
		0x81C, 0x65560003,
		0x81C, 0x64580003,
		0x81C, 0x635A0003,
		0x81C, 0x625C0003,
		0x81C, 0x435E0003,
		0x81C, 0x42600003,
		0x81C, 0x41620003,
		0x81C, 0x40640003,
		0x81C, 0x06660003,
		0x81C, 0x05680003,
		0x81C, 0x046A0003,
		0x81C, 0x036C0003,
		0x81C, 0x026E0003,
		0x81C, 0x01700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xF5000003,
		0x81C, 0xF4020003,
		0x81C, 0xF3040003,
		0x81C, 0xF2060003,
		0x81C, 0xF1080003,
		0x81C, 0xF00A0003,
		0x81C, 0xEF0C0003,
		0x81C, 0xEE0E0003,
		0x81C, 0xED100003,
		0x81C, 0xEC120003,
		0x81C, 0xEB140003,
		0x81C, 0xEA160003,
		0x81C, 0xE9180003,
		0x81C, 0xE81A0003,
		0x81C, 0xE71C0003,
		0x81C, 0xE61E0003,
		0x81C, 0xE5200003,
		0x81C, 0xE4220003,
		0x81C, 0xE3240003,
		0x81C, 0xE2260003,
		0x81C, 0xE1280003,
		0x81C, 0xE02A0003,
		0x81C, 0xC32C0003,
		0x81C, 0xC22E0003,
		0x81C, 0xC1300003,
		0x81C, 0xC0320003,
		0x81C, 0xA4340003,
		0x81C, 0xA3360003,
		0x81C, 0xA2380003,
		0x81C, 0xA13A0003,
		0x81C, 0xA03C0003,
		0x81C, 0x823E0003,
		0x81C, 0x81400003,
		0x81C, 0x80420003,
		0x81C, 0x64440003,
		0x81C, 0x63460003,
		0x81C, 0x62480003,
		0x81C, 0x614A0003,
		0x81C, 0x604C0003,
		0x81C, 0x454E0003,
		0x81C, 0x44500003,
		0x81C, 0x43520003,
		0x81C, 0x42540003,
		0x81C, 0x41560003,
		0x81C, 0x40580003,
		0x81C, 0x055A0003,
		0x81C, 0x045C0003,
		0x81C, 0x035E0003,
		0x81C, 0x02600003,
		0x81C, 0x01620003,
		0x81C, 0x00640003,
		0x81C, 0x00660003,
		0x81C, 0x00680003,
		0x81C, 0x006A0003,
		0x81C, 0x006C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xF5000003,
		0x81C, 0xF4020003,
		0x81C, 0xF3040003,
		0x81C, 0xF2060003,
		0x81C, 0xF1080003,
		0x81C, 0xF00A0003,
		0x81C, 0xEF0C0003,
		0x81C, 0xEE0E0003,
		0x81C, 0xED100003,
		0x81C, 0xEC120003,
		0x81C, 0xEB140003,
		0x81C, 0xEA160003,
		0x81C, 0xE9180003,
		0x81C, 0xE81A0003,
		0x81C, 0xE71C0003,
		0x81C, 0xE61E0003,
		0x81C, 0xE5200003,
		0x81C, 0xE4220003,
		0x81C, 0xE3240003,
		0x81C, 0xE2260003,
		0x81C, 0xE1280003,
		0x81C, 0xE02A0003,
		0x81C, 0xC32C0003,
		0x81C, 0xC22E0003,
		0x81C, 0xC1300003,
		0x81C, 0xC0320003,
		0x81C, 0xA4340003,
		0x81C, 0xA3360003,
		0x81C, 0xA2380003,
		0x81C, 0xA13A0003,
		0x81C, 0xA03C0003,
		0x81C, 0x823E0003,
		0x81C, 0x81400003,
		0x81C, 0x80420003,
		0x81C, 0x64440003,
		0x81C, 0x63460003,
		0x81C, 0x62480003,
		0x81C, 0x614A0003,
		0x81C, 0x604C0003,
		0x81C, 0x454E0003,
		0x81C, 0x44500003,
		0x81C, 0x43520003,
		0x81C, 0x42540003,
		0x81C, 0x41560003,
		0x81C, 0x40580003,
		0x81C, 0x055A0003,
		0x81C, 0x045C0003,
		0x81C, 0x035E0003,
		0x81C, 0x02600003,
		0x81C, 0x01620003,
		0x81C, 0x00640003,
		0x81C, 0x00660003,
		0x81C, 0x00680003,
		0x81C, 0x006A0003,
		0x81C, 0x006C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xEC240003,
		0x81C, 0xEB260003,
		0x81C, 0xEA280003,
		0x81C, 0xE92A0003,
		0x81C, 0xE82C0003,
		0x81C, 0xE72E0003,
		0x81C, 0xE6300003,
		0x81C, 0xE5320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xC1420003,
		0x81C, 0xC0440003,
		0x81C, 0xA3460003,
		0x81C, 0xA2480003,
		0x81C, 0xA14A0003,
		0x81C, 0xA04C0003,
		0x81C, 0x824E0003,
		0x81C, 0x81500003,
		0x81C, 0x80520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x445A0003,
		0x81C, 0x435C0003,
		0x81C, 0x425E0003,
		0x81C, 0x41600003,
		0x81C, 0x40620003,
		0x81C, 0x05640003,
		0x81C, 0x04660003,
		0x81C, 0x03680003,
		0x81C, 0x026A0003,
		0x81C, 0x016C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xF5000003,
		0x81C, 0xF4020003,
		0x81C, 0xF3040003,
		0x81C, 0xF2060003,
		0x81C, 0xF1080003,
		0x81C, 0xF00A0003,
		0x81C, 0xEF0C0003,
		0x81C, 0xEE0E0003,
		0x81C, 0xED100003,
		0x81C, 0xEC120003,
		0x81C, 0xEB140003,
		0x81C, 0xEA160003,
		0x81C, 0xE9180003,
		0x81C, 0xE81A0003,
		0x81C, 0xE71C0003,
		0x81C, 0xE61E0003,
		0x81C, 0xE5200003,
		0x81C, 0xE4220003,
		0x81C, 0xE3240003,
		0x81C, 0xE2260003,
		0x81C, 0xE1280003,
		0x81C, 0xE02A0003,
		0x81C, 0xC32C0003,
		0x81C, 0xC22E0003,
		0x81C, 0xC1300003,
		0x81C, 0xC0320003,
		0x81C, 0xA4340003,
		0x81C, 0xA3360003,
		0x81C, 0xA2380003,
		0x81C, 0xA13A0003,
		0x81C, 0xA03C0003,
		0x81C, 0x823E0003,
		0x81C, 0x81400003,
		0x81C, 0x80420003,
		0x81C, 0x64440003,
		0x81C, 0x63460003,
		0x81C, 0x62480003,
		0x81C, 0x614A0003,
		0x81C, 0x604C0003,
		0x81C, 0x454E0003,
		0x81C, 0x44500003,
		0x81C, 0x43520003,
		0x81C, 0x42540003,
		0x81C, 0x41560003,
		0x81C, 0x40580003,
		0x81C, 0x055A0003,
		0x81C, 0x045C0003,
		0x81C, 0x035E0003,
		0x81C, 0x02600003,
		0x81C, 0x01620003,
		0x81C, 0x00640003,
		0x81C, 0x00660003,
		0x81C, 0x00680003,
		0x81C, 0x006A0003,
		0x81C, 0x006C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xEC240003,
		0x81C, 0xEB260003,
		0x81C, 0xEA280003,
		0x81C, 0xE92A0003,
		0x81C, 0xE82C0003,
		0x81C, 0xE72E0003,
		0x81C, 0xE6300003,
		0x81C, 0xE5320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xC1420003,
		0x81C, 0xC0440003,
		0x81C, 0xA3460003,
		0x81C, 0xA2480003,
		0x81C, 0xA14A0003,
		0x81C, 0xA04C0003,
		0x81C, 0x824E0003,
		0x81C, 0x81500003,
		0x81C, 0x80520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x445A0003,
		0x81C, 0x435C0003,
		0x81C, 0x425E0003,
		0x81C, 0x41600003,
		0x81C, 0x40620003,
		0x81C, 0x05640003,
		0x81C, 0x04660003,
		0x81C, 0x03680003,
		0x81C, 0x026A0003,
		0x81C, 0x016C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xF5000003,
		0x81C, 0xF4020003,
		0x81C, 0xF3040003,
		0x81C, 0xF2060003,
		0x81C, 0xF1080003,
		0x81C, 0xF00A0003,
		0x81C, 0xEF0C0003,
		0x81C, 0xEE0E0003,
		0x81C, 0xED100003,
		0x81C, 0xEC120003,
		0x81C, 0xEB140003,
		0x81C, 0xEA160003,
		0x81C, 0xE9180003,
		0x81C, 0xE81A0003,
		0x81C, 0xE71C0003,
		0x81C, 0xE61E0003,
		0x81C, 0xE5200003,
		0x81C, 0xE4220003,
		0x81C, 0xE3240003,
		0x81C, 0xE2260003,
		0x81C, 0xE1280003,
		0x81C, 0xE02A0003,
		0x81C, 0xC32C0003,
		0x81C, 0xC22E0003,
		0x81C, 0xC1300003,
		0x81C, 0xC0320003,
		0x81C, 0xA4340003,
		0x81C, 0xA3360003,
		0x81C, 0xA2380003,
		0x81C, 0xA13A0003,
		0x81C, 0xA03C0003,
		0x81C, 0x823E0003,
		0x81C, 0x81400003,
		0x81C, 0x80420003,
		0x81C, 0x64440003,
		0x81C, 0x63460003,
		0x81C, 0x62480003,
		0x81C, 0x614A0003,
		0x81C, 0x604C0003,
		0x81C, 0x454E0003,
		0x81C, 0x44500003,
		0x81C, 0x43520003,
		0x81C, 0x42540003,
		0x81C, 0x41560003,
		0x81C, 0x40580003,
		0x81C, 0x055A0003,
		0x81C, 0x045C0003,
		0x81C, 0x035E0003,
		0x81C, 0x02600003,
		0x81C, 0x01620003,
		0x81C, 0x00640003,
		0x81C, 0x00660003,
		0x81C, 0x00680003,
		0x81C, 0x006A0003,
		0x81C, 0x006C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x9000000c,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xEC240003,
		0x81C, 0xEB260003,
		0x81C, 0xEA280003,
		0x81C, 0xE92A0003,
		0x81C, 0xE82C0003,
		0x81C, 0xE72E0003,
		0x81C, 0xE6300003,
		0x81C, 0xE5320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xC1420003,
		0x81C, 0xC0440003,
		0x81C, 0xA3460003,
		0x81C, 0xA2480003,
		0x81C, 0xA14A0003,
		0x81C, 0xA04C0003,
		0x81C, 0x824E0003,
		0x81C, 0x81500003,
		0x81C, 0x80520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x445A0003,
		0x81C, 0x435C0003,
		0x81C, 0x425E0003,
		0x81C, 0x41600003,
		0x81C, 0x40620003,
		0x81C, 0x05640003,
		0x81C, 0x04660003,
		0x81C, 0x03680003,
		0x81C, 0x026A0003,
		0x81C, 0x016C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x9000000d,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xEC240003,
		0x81C, 0xEB260003,
		0x81C, 0xEA280003,
		0x81C, 0xE92A0003,
		0x81C, 0xE82C0003,
		0x81C, 0xE72E0003,
		0x81C, 0xE6300003,
		0x81C, 0xE5320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xC1420003,
		0x81C, 0xC0440003,
		0x81C, 0xA3460003,
		0x81C, 0xA2480003,
		0x81C, 0xA14A0003,
		0x81C, 0xA04C0003,
		0x81C, 0x824E0003,
		0x81C, 0x81500003,
		0x81C, 0x80520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x445A0003,
		0x81C, 0x435C0003,
		0x81C, 0x425E0003,
		0x81C, 0x41600003,
		0x81C, 0x40620003,
		0x81C, 0x05640003,
		0x81C, 0x04660003,
		0x81C, 0x03680003,
		0x81C, 0x026A0003,
		0x81C, 0x016C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x9000000e,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xEC240003,
		0x81C, 0xEB260003,
		0x81C, 0xEA280003,
		0x81C, 0xE92A0003,
		0x81C, 0xE82C0003,
		0x81C, 0xE72E0003,
		0x81C, 0xE6300003,
		0x81C, 0xE5320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xC1420003,
		0x81C, 0xC0440003,
		0x81C, 0xA3460003,
		0x81C, 0xA2480003,
		0x81C, 0xA14A0003,
		0x81C, 0xA04C0003,
		0x81C, 0x824E0003,
		0x81C, 0x81500003,
		0x81C, 0x80520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x445A0003,
		0x81C, 0x435C0003,
		0x81C, 0x425E0003,
		0x81C, 0x41600003,
		0x81C, 0x40620003,
		0x81C, 0x05640003,
		0x81C, 0x04660003,
		0x81C, 0x03680003,
		0x81C, 0x026A0003,
		0x81C, 0x016C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000003,
		0x81C, 0xFE000003,
		0x81C, 0xFD020003,
		0x81C, 0xFC040003,
		0x81C, 0xFB060003,
		0x81C, 0xFA080003,
		0x81C, 0xF90A0003,
		0x81C, 0xF80C0003,
		0x81C, 0xF70E0003,
		0x81C, 0xF6100003,
		0x81C, 0xF5120003,
		0x81C, 0xF4140003,
		0x81C, 0xF3160003,
		0x81C, 0xF2180003,
		0x81C, 0xF11A0003,
		0x81C, 0xF01C0003,
		0x81C, 0xEF1E0003,
		0x81C, 0xEE200003,
		0x81C, 0xED220003,
		0x81C, 0xEC240003,
		0x81C, 0xEB260003,
		0x81C, 0xEA280003,
		0x81C, 0xE92A0003,
		0x81C, 0xE82C0003,
		0x81C, 0xE72E0003,
		0x81C, 0xE6300003,
		0x81C, 0xE5320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xC2400003,
		0x81C, 0xC1420003,
		0x81C, 0xC0440003,
		0x81C, 0xA3460003,
		0x81C, 0xA2480003,
		0x81C, 0xA14A0003,
		0x81C, 0xA04C0003,
		0x81C, 0x824E0003,
		0x81C, 0x81500003,
		0x81C, 0x80520003,
		0x81C, 0x64540003,
		0x81C, 0x63560003,
		0x81C, 0x62580003,
		0x81C, 0x445A0003,
		0x81C, 0x435C0003,
		0x81C, 0x425E0003,
		0x81C, 0x41600003,
		0x81C, 0x40620003,
		0x81C, 0x05640003,
		0x81C, 0x04660003,
		0x81C, 0x03680003,
		0x81C, 0x026A0003,
		0x81C, 0x016C0003,
		0x81C, 0x006E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0xB0000000,	0x00000000,
	0x80000000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEE1C0103,
		0x81C, 0xED1E0103,
		0x81C, 0xEC200103,
		0x81C, 0xEB220103,
		0x81C, 0xEA240103,
		0x81C, 0xE9260103,
		0x81C, 0xE8280103,
		0x81C, 0xE72A0103,
		0x81C, 0xE62C0103,
		0x81C, 0xE52E0103,
		0x81C, 0xE4300103,
		0x81C, 0xE3320103,
		0x81C, 0xE2340103,
		0x81C, 0xC5360103,
		0x81C, 0xC4380103,
		0x81C, 0xC33A0103,
		0x81C, 0xC23C0103,
		0x81C, 0xA53E0103,
		0x81C, 0xA4400103,
		0x81C, 0xA3420103,
		0x81C, 0xA2440103,
		0x81C, 0xA1460103,
		0x81C, 0x83480103,
		0x81C, 0x824A0103,
		0x81C, 0x814C0103,
		0x81C, 0x804E0103,
		0x81C, 0x63500103,
		0x81C, 0x62520103,
		0x81C, 0x61540103,
		0x81C, 0x43560103,
		0x81C, 0x42580103,
		0x81C, 0x415A0103,
		0x81C, 0x405C0103,
		0x81C, 0x225E0103,
		0x81C, 0x21600103,
		0x81C, 0x20620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000103,
		0x81C, 0xF7020103,
		0x81C, 0xF6040103,
		0x81C, 0xF5060103,
		0x81C, 0xF4080103,
		0x81C, 0xF30A0103,
		0x81C, 0xF20C0103,
		0x81C, 0xF10E0103,
		0x81C, 0xF0100103,
		0x81C, 0xEF120103,
		0x81C, 0xEE140103,
		0x81C, 0xED160103,
		0x81C, 0xEC180103,
		0x81C, 0xEB1A0103,
		0x81C, 0xEA1C0103,
		0x81C, 0xE91E0103,
		0x81C, 0xE8200103,
		0x81C, 0xE7220103,
		0x81C, 0xE6240103,
		0x81C, 0xE5260103,
		0x81C, 0xE4280103,
		0x81C, 0xE32A0103,
		0x81C, 0xC32C0103,
		0x81C, 0xC22E0103,
		0x81C, 0xC1300103,
		0x81C, 0xC0320103,
		0x81C, 0xA3340103,
		0x81C, 0xA2360103,
		0x81C, 0xA1380103,
		0x81C, 0xA03A0103,
		0x81C, 0x823C0103,
		0x81C, 0x813E0103,
		0x81C, 0x80400103,
		0x81C, 0x63420103,
		0x81C, 0x62440103,
		0x81C, 0x61460103,
		0x81C, 0x60480103,
		0x81C, 0x424A0103,
		0x81C, 0x414C0103,
		0x81C, 0x404E0103,
		0x81C, 0x06500103,
		0x81C, 0x05520103,
		0x81C, 0x04540103,
		0x81C, 0x03560103,
		0x81C, 0x02580103,
		0x81C, 0x015A0103,
		0x81C, 0x005C0103,
		0x81C, 0x005E0103,
		0x81C, 0x00600103,
		0x81C, 0x00620103,
		0x81C, 0x00640103,
		0x81C, 0x00660103,
		0x81C, 0x00680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000103,
		0x81C, 0xF7020103,
		0x81C, 0xF6040103,
		0x81C, 0xF5060103,
		0x81C, 0xF4080103,
		0x81C, 0xF30A0103,
		0x81C, 0xF20C0103,
		0x81C, 0xF10E0103,
		0x81C, 0xF0100103,
		0x81C, 0xEF120103,
		0x81C, 0xEE140103,
		0x81C, 0xED160103,
		0x81C, 0xEC180103,
		0x81C, 0xEB1A0103,
		0x81C, 0xEA1C0103,
		0x81C, 0xE91E0103,
		0x81C, 0xE8200103,
		0x81C, 0xE7220103,
		0x81C, 0xE6240103,
		0x81C, 0xE5260103,
		0x81C, 0xE4280103,
		0x81C, 0xE32A0103,
		0x81C, 0xC32C0103,
		0x81C, 0xC22E0103,
		0x81C, 0xC1300103,
		0x81C, 0xC0320103,
		0x81C, 0xA3340103,
		0x81C, 0xA2360103,
		0x81C, 0xA1380103,
		0x81C, 0xA03A0103,
		0x81C, 0x823C0103,
		0x81C, 0x813E0103,
		0x81C, 0x80400103,
		0x81C, 0x63420103,
		0x81C, 0x62440103,
		0x81C, 0x61460103,
		0x81C, 0x60480103,
		0x81C, 0x424A0103,
		0x81C, 0x414C0103,
		0x81C, 0x404E0103,
		0x81C, 0x22500103,
		0x81C, 0x21520103,
		0x81C, 0x20540103,
		0x81C, 0x03560103,
		0x81C, 0x02580103,
		0x81C, 0x015A0103,
		0x81C, 0x005C0103,
		0x81C, 0x005E0103,
		0x81C, 0x00600103,
		0x81C, 0x00620103,
		0x81C, 0x00640103,
		0x81C, 0x00660103,
		0x81C, 0x00680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFE000103,
		0x81C, 0xFD020103,
		0x81C, 0xFC040103,
		0x81C, 0xFB060103,
		0x81C, 0xFA080103,
		0x81C, 0xF90A0103,
		0x81C, 0xF80C0103,
		0x81C, 0xF70E0103,
		0x81C, 0xF6100103,
		0x81C, 0xF5120103,
		0x81C, 0xF4140103,
		0x81C, 0xF3160103,
		0x81C, 0xF2180103,
		0x81C, 0xF11A0103,
		0x81C, 0xF01C0103,
		0x81C, 0xEF1E0103,
		0x81C, 0xEE200103,
		0x81C, 0xED220103,
		0x81C, 0xEC240103,
		0x81C, 0xEB260103,
		0x81C, 0xEA280103,
		0x81C, 0xE92A0103,
		0x81C, 0xE82C0103,
		0x81C, 0xE72E0103,
		0x81C, 0xE6300103,
		0x81C, 0xE5320103,
		0x81C, 0xE4340103,
		0x81C, 0xE3360103,
		0x81C, 0xC6380103,
		0x81C, 0xC53A0103,
		0x81C, 0xC43C0103,
		0x81C, 0xC33E0103,
		0x81C, 0xA5400103,
		0x81C, 0xA4420103,
		0x81C, 0xA3440103,
		0x81C, 0xA2460103,
		0x81C, 0xA1480103,
		0x81C, 0xA04A0103,
		0x81C, 0x824C0103,
		0x81C, 0x814E0103,
		0x81C, 0x80500103,
		0x81C, 0x64520103,
		0x81C, 0x63540103,
		0x81C, 0x62560103,
		0x81C, 0x61580103,
		0x81C, 0x605A0103,
		0x81C, 0x235C0103,
		0x81C, 0x225E0103,
		0x81C, 0x21600103,
		0x81C, 0x20620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000103,
		0x81C, 0xF7020103,
		0x81C, 0xF6040103,
		0x81C, 0xF5060103,
		0x81C, 0xF4080103,
		0x81C, 0xF30A0103,
		0x81C, 0xF20C0103,
		0x81C, 0xF10E0103,
		0x81C, 0xF0100103,
		0x81C, 0xEF120103,
		0x81C, 0xEE140103,
		0x81C, 0xED160103,
		0x81C, 0xEC180103,
		0x81C, 0xEB1A0103,
		0x81C, 0xEA1C0103,
		0x81C, 0xE91E0103,
		0x81C, 0xE8200103,
		0x81C, 0xE7220103,
		0x81C, 0xE6240103,
		0x81C, 0xE5260103,
		0x81C, 0xE4280103,
		0x81C, 0xE32A0103,
		0x81C, 0xC32C0103,
		0x81C, 0xC22E0103,
		0x81C, 0xC1300103,
		0x81C, 0xC0320103,
		0x81C, 0xA3340103,
		0x81C, 0xA2360103,
		0x81C, 0xA1380103,
		0x81C, 0xA03A0103,
		0x81C, 0x823C0103,
		0x81C, 0x813E0103,
		0x81C, 0x80400103,
		0x81C, 0x63420103,
		0x81C, 0x62440103,
		0x81C, 0x61460103,
		0x81C, 0x60480103,
		0x81C, 0x424A0103,
		0x81C, 0x414C0103,
		0x81C, 0x404E0103,
		0x81C, 0x22500103,
		0x81C, 0x21520103,
		0x81C, 0x20540103,
		0x81C, 0x03560103,
		0x81C, 0x02580103,
		0x81C, 0x015A0103,
		0x81C, 0x005C0103,
		0x81C, 0x005E0103,
		0x81C, 0x00600103,
		0x81C, 0x00620103,
		0x81C, 0x00640103,
		0x81C, 0x00660103,
		0x81C, 0x00680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEF1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xE72C0103,
		0x81C, 0xE62E0103,
		0x81C, 0xE5300103,
		0x81C, 0xE4320103,
		0x81C, 0xE3340103,
		0x81C, 0xE2360103,
		0x81C, 0xC5380103,
		0x81C, 0xC43A0103,
		0x81C, 0xC33C0103,
		0x81C, 0xC23E0103,
		0x81C, 0xA5400103,
		0x81C, 0xA4420103,
		0x81C, 0xA3440103,
		0x81C, 0xA2460103,
		0x81C, 0xA1480103,
		0x81C, 0x834A0103,
		0x81C, 0x824C0103,
		0x81C, 0x814E0103,
		0x81C, 0x64500103,
		0x81C, 0x63520103,
		0x81C, 0x62540103,
		0x81C, 0x61560103,
		0x81C, 0x42580103,
		0x81C, 0x415A0103,
		0x81C, 0x405C0103,
		0x81C, 0x065E0103,
		0x81C, 0x05600103,
		0x81C, 0x04620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFA000103,
		0x81C, 0xF9020103,
		0x81C, 0xF8040103,
		0x81C, 0xF7060103,
		0x81C, 0xF6080103,
		0x81C, 0xF50A0103,
		0x81C, 0xF40C0103,
		0x81C, 0xF30E0103,
		0x81C, 0xF2100103,
		0x81C, 0xF1120103,
		0x81C, 0xF0140103,
		0x81C, 0xEF160103,
		0x81C, 0xEE180103,
		0x81C, 0xED1A0103,
		0x81C, 0xEC1C0103,
		0x81C, 0xEB1E0103,
		0x81C, 0xEA200103,
		0x81C, 0xE9220103,
		0x81C, 0xE8240103,
		0x81C, 0xE7260103,
		0x81C, 0xE6280103,
		0x81C, 0xE52A0103,
		0x81C, 0xC42C0103,
		0x81C, 0xC32E0103,
		0x81C, 0xC2300103,
		0x81C, 0xC1320103,
		0x81C, 0xA4340103,
		0x81C, 0xA3360103,
		0x81C, 0xA2380103,
		0x81C, 0xA13A0103,
		0x81C, 0x833C0103,
		0x81C, 0x823E0103,
		0x81C, 0x81400103,
		0x81C, 0x63420103,
		0x81C, 0x62440103,
		0x81C, 0x61460103,
		0x81C, 0x60480103,
		0x81C, 0x424A0103,
		0x81C, 0x414C0103,
		0x81C, 0x404E0103,
		0x81C, 0x22500103,
		0x81C, 0x21520103,
		0x81C, 0x20540103,
		0x81C, 0x03560103,
		0x81C, 0x02580103,
		0x81C, 0x015A0103,
		0x81C, 0x005C0103,
		0x81C, 0x005E0103,
		0x81C, 0x00600103,
		0x81C, 0x00620103,
		0x81C, 0x00640103,
		0x81C, 0x00660103,
		0x81C, 0x00680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000103,
		0x81C, 0xF7020103,
		0x81C, 0xF6040103,
		0x81C, 0xF5060103,
		0x81C, 0xF4080103,
		0x81C, 0xF30A0103,
		0x81C, 0xF20C0103,
		0x81C, 0xF10E0103,
		0x81C, 0xF0100103,
		0x81C, 0xEF120103,
		0x81C, 0xEE140103,
		0x81C, 0xED160103,
		0x81C, 0xEC180103,
		0x81C, 0xEB1A0103,
		0x81C, 0xEA1C0103,
		0x81C, 0xE91E0103,
		0x81C, 0xE8200103,
		0x81C, 0xE7220103,
		0x81C, 0xE6240103,
		0x81C, 0xE5260103,
		0x81C, 0xE4280103,
		0x81C, 0xE32A0103,
		0x81C, 0xE22C0103,
		0x81C, 0xC32E0103,
		0x81C, 0xC2300103,
		0x81C, 0xC1320103,
		0x81C, 0xA3340103,
		0x81C, 0xA2360103,
		0x81C, 0xA1380103,
		0x81C, 0xA03A0103,
		0x81C, 0x823C0103,
		0x81C, 0x813E0103,
		0x81C, 0x80400103,
		0x81C, 0x64420103,
		0x81C, 0x63440103,
		0x81C, 0x62460103,
		0x81C, 0x61480103,
		0x81C, 0x434A0103,
		0x81C, 0x424C0103,
		0x81C, 0x414E0103,
		0x81C, 0x40500103,
		0x81C, 0x22520103,
		0x81C, 0x21540103,
		0x81C, 0x20560103,
		0x81C, 0x04580103,
		0x81C, 0x035A0103,
		0x81C, 0x025C0103,
		0x81C, 0x015E0103,
		0x81C, 0x00600103,
		0x81C, 0x00620103,
		0x81C, 0x00640103,
		0x81C, 0x00660103,
		0x81C, 0x00680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEF1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xE72C0103,
		0x81C, 0xE62E0103,
		0x81C, 0xE5300103,
		0x81C, 0xE4320103,
		0x81C, 0xE3340103,
		0x81C, 0xC6360103,
		0x81C, 0xC5380103,
		0x81C, 0xC43A0103,
		0x81C, 0xC33C0103,
		0x81C, 0xC23E0103,
		0x81C, 0xA5400103,
		0x81C, 0xA4420103,
		0x81C, 0xA3440103,
		0x81C, 0xA2460103,
		0x81C, 0xA1480103,
		0x81C, 0x834A0103,
		0x81C, 0x824C0103,
		0x81C, 0x814E0103,
		0x81C, 0x63500103,
		0x81C, 0x62520103,
		0x81C, 0x61540103,
		0x81C, 0x43560103,
		0x81C, 0x42580103,
		0x81C, 0x245A0103,
		0x81C, 0x235C0103,
		0x81C, 0x225E0103,
		0x81C, 0x21600103,
		0x81C, 0x04620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000103,
		0x81C, 0xF7020103,
		0x81C, 0xF6040103,
		0x81C, 0xF5060103,
		0x81C, 0xF4080103,
		0x81C, 0xF30A0103,
		0x81C, 0xF20C0103,
		0x81C, 0xF10E0103,
		0x81C, 0xF0100103,
		0x81C, 0xEF120103,
		0x81C, 0xEE140103,
		0x81C, 0xED160103,
		0x81C, 0xEC180103,
		0x81C, 0xEB1A0103,
		0x81C, 0xEA1C0103,
		0x81C, 0xE91E0103,
		0x81C, 0xE8200103,
		0x81C, 0xE7220103,
		0x81C, 0xE6240103,
		0x81C, 0xE5260103,
		0x81C, 0xE4280103,
		0x81C, 0xE32A0103,
		0x81C, 0xE22C0103,
		0x81C, 0xC32E0103,
		0x81C, 0xC2300103,
		0x81C, 0xC1320103,
		0x81C, 0xA3340103,
		0x81C, 0xA2360103,
		0x81C, 0xA1380103,
		0x81C, 0xA03A0103,
		0x81C, 0x823C0103,
		0x81C, 0x813E0103,
		0x81C, 0x80400103,
		0x81C, 0x64420103,
		0x81C, 0x63440103,
		0x81C, 0x62460103,
		0x81C, 0x61480103,
		0x81C, 0x434A0103,
		0x81C, 0x424C0103,
		0x81C, 0x414E0103,
		0x81C, 0x40500103,
		0x81C, 0x22520103,
		0x81C, 0x21540103,
		0x81C, 0x20560103,
		0x81C, 0x04580103,
		0x81C, 0x035A0103,
		0x81C, 0x025C0103,
		0x81C, 0x015E0103,
		0x81C, 0x00600103,
		0x81C, 0x00620103,
		0x81C, 0x00640103,
		0x81C, 0x00660103,
		0x81C, 0x00680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEE1C0103,
		0x81C, 0xED1E0103,
		0x81C, 0xEC200103,
		0x81C, 0xEB220103,
		0x81C, 0xEA240103,
		0x81C, 0xE9260103,
		0x81C, 0xE8280103,
		0x81C, 0xE72A0103,
		0x81C, 0xE62C0103,
		0x81C, 0xE52E0103,
		0x81C, 0xE4300103,
		0x81C, 0xE3320103,
		0x81C, 0xE2340103,
		0x81C, 0xC5360103,
		0x81C, 0xC4380103,
		0x81C, 0xC33A0103,
		0x81C, 0xC23C0103,
		0x81C, 0xA53E0103,
		0x81C, 0xA4400103,
		0x81C, 0xA3420103,
		0x81C, 0xA2440103,
		0x81C, 0xA1460103,
		0x81C, 0x83480103,
		0x81C, 0x824A0103,
		0x81C, 0x814C0103,
		0x81C, 0x804E0103,
		0x81C, 0x63500103,
		0x81C, 0x62520103,
		0x81C, 0x61540103,
		0x81C, 0x43560103,
		0x81C, 0x42580103,
		0x81C, 0x415A0103,
		0x81C, 0x405C0103,
		0x81C, 0x225E0103,
		0x81C, 0x21600103,
		0x81C, 0x20620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF9000103,
		0x81C, 0xF8020103,
		0x81C, 0xF7040103,
		0x81C, 0xF6060103,
		0x81C, 0xF5080103,
		0x81C, 0xF40A0103,
		0x81C, 0xF30C0103,
		0x81C, 0xF20E0103,
		0x81C, 0xF1100103,
		0x81C, 0xF0120103,
		0x81C, 0xEF140103,
		0x81C, 0xEE160103,
		0x81C, 0xED180103,
		0x81C, 0xEC1A0103,
		0x81C, 0xEB1C0103,
		0x81C, 0xEA1E0103,
		0x81C, 0xE9200103,
		0x81C, 0xE8220103,
		0x81C, 0xE7240103,
		0x81C, 0xE6260103,
		0x81C, 0xE5280103,
		0x81C, 0xE42A0103,
		0x81C, 0xE32C0103,
		0x81C, 0xC32E0103,
		0x81C, 0xC2300103,
		0x81C, 0xC1320103,
		0x81C, 0xA4340103,
		0x81C, 0xA3360103,
		0x81C, 0xA2380103,
		0x81C, 0xA13A0103,
		0x81C, 0xA03C0103,
		0x81C, 0x823E0103,
		0x81C, 0x81400103,
		0x81C, 0x80420103,
		0x81C, 0x63440103,
		0x81C, 0x62460103,
		0x81C, 0x61480103,
		0x81C, 0x604A0103,
		0x81C, 0x244C0103,
		0x81C, 0x234E0103,
		0x81C, 0x22500103,
		0x81C, 0x21520103,
		0x81C, 0x20540103,
		0x81C, 0x05560103,
		0x81C, 0x04580103,
		0x81C, 0x035A0103,
		0x81C, 0x025C0103,
		0x81C, 0x015E0103,
		0x81C, 0x00600103,
		0x81C, 0x00620103,
		0x81C, 0x00640103,
		0x81C, 0x00660103,
		0x81C, 0x00680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x9000000c,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEE1C0103,
		0x81C, 0xED1E0103,
		0x81C, 0xEC200103,
		0x81C, 0xEB220103,
		0x81C, 0xEA240103,
		0x81C, 0xE9260103,
		0x81C, 0xE8280103,
		0x81C, 0xE72A0103,
		0x81C, 0xE62C0103,
		0x81C, 0xE52E0103,
		0x81C, 0xE4300103,
		0x81C, 0xE3320103,
		0x81C, 0xE2340103,
		0x81C, 0xC5360103,
		0x81C, 0xC4380103,
		0x81C, 0xC33A0103,
		0x81C, 0xC23C0103,
		0x81C, 0xA53E0103,
		0x81C, 0xA4400103,
		0x81C, 0xA3420103,
		0x81C, 0xA2440103,
		0x81C, 0xA1460103,
		0x81C, 0x83480103,
		0x81C, 0x824A0103,
		0x81C, 0x814C0103,
		0x81C, 0x804E0103,
		0x81C, 0x63500103,
		0x81C, 0x62520103,
		0x81C, 0x61540103,
		0x81C, 0x43560103,
		0x81C, 0x42580103,
		0x81C, 0x415A0103,
		0x81C, 0x405C0103,
		0x81C, 0x225E0103,
		0x81C, 0x21600103,
		0x81C, 0x20620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x9000000d,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEE1C0103,
		0x81C, 0xED1E0103,
		0x81C, 0xEC200103,
		0x81C, 0xEB220103,
		0x81C, 0xEA240103,
		0x81C, 0xE9260103,
		0x81C, 0xE8280103,
		0x81C, 0xE72A0103,
		0x81C, 0xE62C0103,
		0x81C, 0xE52E0103,
		0x81C, 0xE4300103,
		0x81C, 0xE3320103,
		0x81C, 0xE2340103,
		0x81C, 0xC5360103,
		0x81C, 0xC4380103,
		0x81C, 0xC33A0103,
		0x81C, 0xC23C0103,
		0x81C, 0xA53E0103,
		0x81C, 0xA4400103,
		0x81C, 0xA3420103,
		0x81C, 0xA2440103,
		0x81C, 0xA1460103,
		0x81C, 0x83480103,
		0x81C, 0x824A0103,
		0x81C, 0x814C0103,
		0x81C, 0x804E0103,
		0x81C, 0x63500103,
		0x81C, 0x62520103,
		0x81C, 0x61540103,
		0x81C, 0x43560103,
		0x81C, 0x42580103,
		0x81C, 0x415A0103,
		0x81C, 0x405C0103,
		0x81C, 0x225E0103,
		0x81C, 0x21600103,
		0x81C, 0x20620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0x9000000e,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEE1C0103,
		0x81C, 0xED1E0103,
		0x81C, 0xEC200103,
		0x81C, 0xEB220103,
		0x81C, 0xEA240103,
		0x81C, 0xE9260103,
		0x81C, 0xE8280103,
		0x81C, 0xE72A0103,
		0x81C, 0xE62C0103,
		0x81C, 0xE52E0103,
		0x81C, 0xE4300103,
		0x81C, 0xE3320103,
		0x81C, 0xE2340103,
		0x81C, 0xC5360103,
		0x81C, 0xC4380103,
		0x81C, 0xC33A0103,
		0x81C, 0xC23C0103,
		0x81C, 0xA53E0103,
		0x81C, 0xA4400103,
		0x81C, 0xA3420103,
		0x81C, 0xA2440103,
		0x81C, 0xA1460103,
		0x81C, 0x83480103,
		0x81C, 0x824A0103,
		0x81C, 0x814C0103,
		0x81C, 0x804E0103,
		0x81C, 0x63500103,
		0x81C, 0x62520103,
		0x81C, 0x61540103,
		0x81C, 0x43560103,
		0x81C, 0x42580103,
		0x81C, 0x415A0103,
		0x81C, 0x405C0103,
		0x81C, 0x225E0103,
		0x81C, 0x21600103,
		0x81C, 0x20620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0xA0000000,	0x00000000,
		0x81C, 0xFE000103,
		0x81C, 0xFD020103,
		0x81C, 0xFC040103,
		0x81C, 0xFB060103,
		0x81C, 0xFA080103,
		0x81C, 0xF90A0103,
		0x81C, 0xF80C0103,
		0x81C, 0xF70E0103,
		0x81C, 0xF6100103,
		0x81C, 0xF5120103,
		0x81C, 0xF4140103,
		0x81C, 0xF3160103,
		0x81C, 0xF2180103,
		0x81C, 0xF11A0103,
		0x81C, 0xF01C0103,
		0x81C, 0xEF1E0103,
		0x81C, 0xEE200103,
		0x81C, 0xED220103,
		0x81C, 0xEC240103,
		0x81C, 0xEB260103,
		0x81C, 0xEA280103,
		0x81C, 0xE92A0103,
		0x81C, 0xE82C0103,
		0x81C, 0xE72E0103,
		0x81C, 0xE6300103,
		0x81C, 0xE5320103,
		0x81C, 0xE4340103,
		0x81C, 0xE3360103,
		0x81C, 0xC6380103,
		0x81C, 0xC53A0103,
		0x81C, 0xC43C0103,
		0x81C, 0xC33E0103,
		0x81C, 0xA5400103,
		0x81C, 0xA4420103,
		0x81C, 0xA3440103,
		0x81C, 0xA2460103,
		0x81C, 0xA1480103,
		0x81C, 0xA04A0103,
		0x81C, 0x824C0103,
		0x81C, 0x814E0103,
		0x81C, 0x80500103,
		0x81C, 0x64520103,
		0x81C, 0x63540103,
		0x81C, 0x62560103,
		0x81C, 0x61580103,
		0x81C, 0x605A0103,
		0x81C, 0x235C0103,
		0x81C, 0x225E0103,
		0x81C, 0x21600103,
		0x81C, 0x20620103,
		0x81C, 0x03640103,
		0x81C, 0x02660103,
		0x81C, 0x01680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0xB0000000,	0x00000000,
	0x80000000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xC6340203,
		0x81C, 0xC5360203,
		0x81C, 0xC4380203,
		0x81C, 0xC33A0203,
		0x81C, 0xA63C0203,
		0x81C, 0xA53E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0x83480203,
		0x81C, 0x824A0203,
		0x81C, 0x814C0203,
		0x81C, 0x804E0203,
		0x81C, 0x63500203,
		0x81C, 0x62520203,
		0x81C, 0x61540203,
		0x81C, 0x42560203,
		0x81C, 0x41580203,
		0x81C, 0x405A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x20600203,
		0x81C, 0x04620203,
		0x81C, 0x03640203,
		0x81C, 0x02660203,
		0x81C, 0x01680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF7000203,
		0x81C, 0xF6020203,
		0x81C, 0xF5040203,
		0x81C, 0xF4060203,
		0x81C, 0xF3080203,
		0x81C, 0xF20A0203,
		0x81C, 0xF10C0203,
		0x81C, 0xF00E0203,
		0x81C, 0xEF100203,
		0x81C, 0xEE120203,
		0x81C, 0xED140203,
		0x81C, 0xEC160203,
		0x81C, 0xEB180203,
		0x81C, 0xEA1A0203,
		0x81C, 0xE91C0203,
		0x81C, 0xE81E0203,
		0x81C, 0xE7200203,
		0x81C, 0xE6220203,
		0x81C, 0xE5240203,
		0x81C, 0xE4260203,
		0x81C, 0xE3280203,
		0x81C, 0xC42A0203,
		0x81C, 0xC32C0203,
		0x81C, 0xC22E0203,
		0x81C, 0xC1300203,
		0x81C, 0xC0320203,
		0x81C, 0xA3340203,
		0x81C, 0xA2360203,
		0x81C, 0xA1380203,
		0x81C, 0xA03A0203,
		0x81C, 0x823C0203,
		0x81C, 0x813E0203,
		0x81C, 0x80400203,
		0x81C, 0x63420203,
		0x81C, 0x62440203,
		0x81C, 0x61460203,
		0x81C, 0x60480203,
		0x81C, 0x424A0203,
		0x81C, 0x414C0203,
		0x81C, 0x404E0203,
		0x81C, 0x06500203,
		0x81C, 0x05520203,
		0x81C, 0x04540203,
		0x81C, 0x03560203,
		0x81C, 0x02580203,
		0x81C, 0x015A0203,
		0x81C, 0x005C0203,
		0x81C, 0x005E0203,
		0x81C, 0x00600203,
		0x81C, 0x00620203,
		0x81C, 0x00640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF7000203,
		0x81C, 0xF6020203,
		0x81C, 0xF5040203,
		0x81C, 0xF4060203,
		0x81C, 0xF3080203,
		0x81C, 0xF20A0203,
		0x81C, 0xF10C0203,
		0x81C, 0xF00E0203,
		0x81C, 0xEF100203,
		0x81C, 0xEE120203,
		0x81C, 0xED140203,
		0x81C, 0xEC160203,
		0x81C, 0xEB180203,
		0x81C, 0xEA1A0203,
		0x81C, 0xE91C0203,
		0x81C, 0xE81E0203,
		0x81C, 0xE7200203,
		0x81C, 0xE6220203,
		0x81C, 0xE5240203,
		0x81C, 0xE4260203,
		0x81C, 0xE3280203,
		0x81C, 0xC42A0203,
		0x81C, 0xC32C0203,
		0x81C, 0xC22E0203,
		0x81C, 0xC1300203,
		0x81C, 0xC0320203,
		0x81C, 0xA3340203,
		0x81C, 0xA2360203,
		0x81C, 0xA1380203,
		0x81C, 0xA03A0203,
		0x81C, 0x823C0203,
		0x81C, 0x813E0203,
		0x81C, 0x80400203,
		0x81C, 0x64420203,
		0x81C, 0x63440203,
		0x81C, 0x62460203,
		0x81C, 0x61480203,
		0x81C, 0x604A0203,
		0x81C, 0x414C0203,
		0x81C, 0x404E0203,
		0x81C, 0x22500203,
		0x81C, 0x21520203,
		0x81C, 0x20540203,
		0x81C, 0x03560203,
		0x81C, 0x02580203,
		0x81C, 0x015A0203,
		0x81C, 0x005C0203,
		0x81C, 0x005E0203,
		0x81C, 0x00600203,
		0x81C, 0x00620203,
		0x81C, 0x00640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEF1A0203,
		0x81C, 0xEE1C0203,
		0x81C, 0xED1E0203,
		0x81C, 0xEC200203,
		0x81C, 0xEB220203,
		0x81C, 0xEA240203,
		0x81C, 0xE9260203,
		0x81C, 0xE8280203,
		0x81C, 0xE72A0203,
		0x81C, 0xE62C0203,
		0x81C, 0xE52E0203,
		0x81C, 0xE4300203,
		0x81C, 0xE3320203,
		0x81C, 0xE2340203,
		0x81C, 0xC6360203,
		0x81C, 0xC5380203,
		0x81C, 0xC43A0203,
		0x81C, 0xC33C0203,
		0x81C, 0xA63E0203,
		0x81C, 0xA5400203,
		0x81C, 0xA4420203,
		0x81C, 0xA3440203,
		0x81C, 0xA2460203,
		0x81C, 0xA1480203,
		0x81C, 0x834A0203,
		0x81C, 0x824C0203,
		0x81C, 0x814E0203,
		0x81C, 0x64500203,
		0x81C, 0x63520203,
		0x81C, 0x62540203,
		0x81C, 0x61560203,
		0x81C, 0x60580203,
		0x81C, 0x405A0203,
		0x81C, 0x215C0203,
		0x81C, 0x205E0203,
		0x81C, 0x03600203,
		0x81C, 0x02620203,
		0x81C, 0x01640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF7000203,
		0x81C, 0xF6020203,
		0x81C, 0xF5040203,
		0x81C, 0xF4060203,
		0x81C, 0xF3080203,
		0x81C, 0xF20A0203,
		0x81C, 0xF10C0203,
		0x81C, 0xF00E0203,
		0x81C, 0xEF100203,
		0x81C, 0xEE120203,
		0x81C, 0xED140203,
		0x81C, 0xEC160203,
		0x81C, 0xEB180203,
		0x81C, 0xEA1A0203,
		0x81C, 0xE91C0203,
		0x81C, 0xE81E0203,
		0x81C, 0xE7200203,
		0x81C, 0xE6220203,
		0x81C, 0xE5240203,
		0x81C, 0xE4260203,
		0x81C, 0xE3280203,
		0x81C, 0xC42A0203,
		0x81C, 0xC32C0203,
		0x81C, 0xC22E0203,
		0x81C, 0xC1300203,
		0x81C, 0xC0320203,
		0x81C, 0xA3340203,
		0x81C, 0xA2360203,
		0x81C, 0xA1380203,
		0x81C, 0xA03A0203,
		0x81C, 0x823C0203,
		0x81C, 0x813E0203,
		0x81C, 0x80400203,
		0x81C, 0x64420203,
		0x81C, 0x63440203,
		0x81C, 0x62460203,
		0x81C, 0x61480203,
		0x81C, 0x604A0203,
		0x81C, 0x414C0203,
		0x81C, 0x404E0203,
		0x81C, 0x22500203,
		0x81C, 0x21520203,
		0x81C, 0x20540203,
		0x81C, 0x03560203,
		0x81C, 0x02580203,
		0x81C, 0x015A0203,
		0x81C, 0x005C0203,
		0x81C, 0x005E0203,
		0x81C, 0x00600203,
		0x81C, 0x00620203,
		0x81C, 0x00640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEF1A0203,
		0x81C, 0xEE1C0203,
		0x81C, 0xED1E0203,
		0x81C, 0xEC200203,
		0x81C, 0xEB220203,
		0x81C, 0xEA240203,
		0x81C, 0xE9260203,
		0x81C, 0xE8280203,
		0x81C, 0xE72A0203,
		0x81C, 0xE62C0203,
		0x81C, 0xE52E0203,
		0x81C, 0xE4300203,
		0x81C, 0xE3320203,
		0x81C, 0xE2340203,
		0x81C, 0xE1360203,
		0x81C, 0xC5380203,
		0x81C, 0xC43A0203,
		0x81C, 0xC33C0203,
		0x81C, 0xC23E0203,
		0x81C, 0xC1400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0xA0480203,
		0x81C, 0x834A0203,
		0x81C, 0x824C0203,
		0x81C, 0x814E0203,
		0x81C, 0x64500203,
		0x81C, 0x63520203,
		0x81C, 0x62540203,
		0x81C, 0x61560203,
		0x81C, 0x25580203,
		0x81C, 0x245A0203,
		0x81C, 0x235C0203,
		0x81C, 0x225E0203,
		0x81C, 0x21600203,
		0x81C, 0x04620203,
		0x81C, 0x03640203,
		0x81C, 0x02660203,
		0x81C, 0x01680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF9000203,
		0x81C, 0xF8020203,
		0x81C, 0xF7040203,
		0x81C, 0xF6060203,
		0x81C, 0xF5080203,
		0x81C, 0xF40A0203,
		0x81C, 0xF30C0203,
		0x81C, 0xF20E0203,
		0x81C, 0xF1100203,
		0x81C, 0xF0120203,
		0x81C, 0xEF140203,
		0x81C, 0xEE160203,
		0x81C, 0xED180203,
		0x81C, 0xEC1A0203,
		0x81C, 0xEB1C0203,
		0x81C, 0xEA1E0203,
		0x81C, 0xE9200203,
		0x81C, 0xE8220203,
		0x81C, 0xE7240203,
		0x81C, 0xE6260203,
		0x81C, 0xE5280203,
		0x81C, 0xC42A0203,
		0x81C, 0xC32C0203,
		0x81C, 0xC22E0203,
		0x81C, 0xC1300203,
		0x81C, 0xC0320203,
		0x81C, 0xA3340203,
		0x81C, 0xA2360203,
		0x81C, 0xA1380203,
		0x81C, 0xA03A0203,
		0x81C, 0x823C0203,
		0x81C, 0x813E0203,
		0x81C, 0x80400203,
		0x81C, 0x64420203,
		0x81C, 0x63440203,
		0x81C, 0x62460203,
		0x81C, 0x61480203,
		0x81C, 0x604A0203,
		0x81C, 0x414C0203,
		0x81C, 0x404E0203,
		0x81C, 0x22500203,
		0x81C, 0x21520203,
		0x81C, 0x20540203,
		0x81C, 0x03560203,
		0x81C, 0x02580203,
		0x81C, 0x015A0203,
		0x81C, 0x005C0203,
		0x81C, 0x005E0203,
		0x81C, 0x00600203,
		0x81C, 0x00620203,
		0x81C, 0x00640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000203,
		0x81C, 0xF7020203,
		0x81C, 0xF6040203,
		0x81C, 0xF5060203,
		0x81C, 0xF4080203,
		0x81C, 0xF30A0203,
		0x81C, 0xF20C0203,
		0x81C, 0xF10E0203,
		0x81C, 0xF0100203,
		0x81C, 0xEF120203,
		0x81C, 0xEE140203,
		0x81C, 0xED160203,
		0x81C, 0xEC180203,
		0x81C, 0xEB1A0203,
		0x81C, 0xEA1C0203,
		0x81C, 0xE91E0203,
		0x81C, 0xE8200203,
		0x81C, 0xE7220203,
		0x81C, 0xE6240203,
		0x81C, 0xE5260203,
		0x81C, 0xE4280203,
		0x81C, 0xE32A0203,
		0x81C, 0xC42C0203,
		0x81C, 0xC32E0203,
		0x81C, 0xC2300203,
		0x81C, 0xC1320203,
		0x81C, 0xA3340203,
		0x81C, 0xA2360203,
		0x81C, 0xA1380203,
		0x81C, 0xA03A0203,
		0x81C, 0x823C0203,
		0x81C, 0x813E0203,
		0x81C, 0x80400203,
		0x81C, 0x65420203,
		0x81C, 0x64440203,
		0x81C, 0x63460203,
		0x81C, 0x62480203,
		0x81C, 0x614A0203,
		0x81C, 0x424C0203,
		0x81C, 0x414E0203,
		0x81C, 0x40500203,
		0x81C, 0x22520203,
		0x81C, 0x21540203,
		0x81C, 0x20560203,
		0x81C, 0x04580203,
		0x81C, 0x035A0203,
		0x81C, 0x025C0203,
		0x81C, 0x015E0203,
		0x81C, 0x00600203,
		0x81C, 0x00620203,
		0x81C, 0x00640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000203,
		0x81C, 0xFA020203,
		0x81C, 0xF9040203,
		0x81C, 0xF8060203,
		0x81C, 0xF7080203,
		0x81C, 0xF60A0203,
		0x81C, 0xF50C0203,
		0x81C, 0xF40E0203,
		0x81C, 0xF3100203,
		0x81C, 0xF2120203,
		0x81C, 0xF1140203,
		0x81C, 0xF0160203,
		0x81C, 0xEF180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xC6340203,
		0x81C, 0xC5360203,
		0x81C, 0xC4380203,
		0x81C, 0xC33A0203,
		0x81C, 0xC23C0203,
		0x81C, 0xC13E0203,
		0x81C, 0xC0400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0xA0480203,
		0x81C, 0x824A0203,
		0x81C, 0x814C0203,
		0x81C, 0x804E0203,
		0x81C, 0x63500203,
		0x81C, 0x62520203,
		0x81C, 0x61540203,
		0x81C, 0x60560203,
		0x81C, 0x24580203,
		0x81C, 0x235A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x20600203,
		0x81C, 0x03620203,
		0x81C, 0x02640203,
		0x81C, 0x01660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000203,
		0x81C, 0xF7020203,
		0x81C, 0xF6040203,
		0x81C, 0xF5060203,
		0x81C, 0xF4080203,
		0x81C, 0xF30A0203,
		0x81C, 0xF20C0203,
		0x81C, 0xF10E0203,
		0x81C, 0xF0100203,
		0x81C, 0xEF120203,
		0x81C, 0xEE140203,
		0x81C, 0xED160203,
		0x81C, 0xEC180203,
		0x81C, 0xEB1A0203,
		0x81C, 0xEA1C0203,
		0x81C, 0xE91E0203,
		0x81C, 0xE8200203,
		0x81C, 0xE7220203,
		0x81C, 0xE6240203,
		0x81C, 0xE5260203,
		0x81C, 0xE4280203,
		0x81C, 0xE32A0203,
		0x81C, 0xC42C0203,
		0x81C, 0xC32E0203,
		0x81C, 0xC2300203,
		0x81C, 0xC1320203,
		0x81C, 0xA3340203,
		0x81C, 0xA2360203,
		0x81C, 0xA1380203,
		0x81C, 0xA03A0203,
		0x81C, 0x823C0203,
		0x81C, 0x813E0203,
		0x81C, 0x80400203,
		0x81C, 0x65420203,
		0x81C, 0x64440203,
		0x81C, 0x63460203,
		0x81C, 0x62480203,
		0x81C, 0x614A0203,
		0x81C, 0x424C0203,
		0x81C, 0x414E0203,
		0x81C, 0x40500203,
		0x81C, 0x22520203,
		0x81C, 0x21540203,
		0x81C, 0x20560203,
		0x81C, 0x04580203,
		0x81C, 0x035A0203,
		0x81C, 0x025C0203,
		0x81C, 0x015E0203,
		0x81C, 0x00600203,
		0x81C, 0x00620203,
		0x81C, 0x00640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xC6340203,
		0x81C, 0xC5360203,
		0x81C, 0xC4380203,
		0x81C, 0xC33A0203,
		0x81C, 0xA63C0203,
		0x81C, 0xA53E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0x83480203,
		0x81C, 0x824A0203,
		0x81C, 0x814C0203,
		0x81C, 0x804E0203,
		0x81C, 0x63500203,
		0x81C, 0x62520203,
		0x81C, 0x61540203,
		0x81C, 0x42560203,
		0x81C, 0x41580203,
		0x81C, 0x405A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x20600203,
		0x81C, 0x04620203,
		0x81C, 0x03640203,
		0x81C, 0x02660203,
		0x81C, 0x01680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF9000203,
		0x81C, 0xF8020203,
		0x81C, 0xF7040203,
		0x81C, 0xF6060203,
		0x81C, 0xF5080203,
		0x81C, 0xF40A0203,
		0x81C, 0xF30C0203,
		0x81C, 0xF20E0203,
		0x81C, 0xF1100203,
		0x81C, 0xF0120203,
		0x81C, 0xEF140203,
		0x81C, 0xEE160203,
		0x81C, 0xED180203,
		0x81C, 0xEC1A0203,
		0x81C, 0xEB1C0203,
		0x81C, 0xEA1E0203,
		0x81C, 0xE9200203,
		0x81C, 0xE8220203,
		0x81C, 0xE7240203,
		0x81C, 0xE6260203,
		0x81C, 0xE5280203,
		0x81C, 0xE42A0203,
		0x81C, 0xC42C0203,
		0x81C, 0xC32E0203,
		0x81C, 0xC2300203,
		0x81C, 0xC1320203,
		0x81C, 0xA3340203,
		0x81C, 0xA2360203,
		0x81C, 0xA1380203,
		0x81C, 0xA03A0203,
		0x81C, 0x823C0203,
		0x81C, 0x813E0203,
		0x81C, 0x80400203,
		0x81C, 0x64420203,
		0x81C, 0x63440203,
		0x81C, 0x62460203,
		0x81C, 0x61480203,
		0x81C, 0x604A0203,
		0x81C, 0x244C0203,
		0x81C, 0x234E0203,
		0x81C, 0x22500203,
		0x81C, 0x21520203,
		0x81C, 0x20540203,
		0x81C, 0x05560203,
		0x81C, 0x04580203,
		0x81C, 0x035A0203,
		0x81C, 0x025C0203,
		0x81C, 0x015E0203,
		0x81C, 0x00600203,
		0x81C, 0x00620203,
		0x81C, 0x00640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x9000000c,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xC6340203,
		0x81C, 0xC5360203,
		0x81C, 0xC4380203,
		0x81C, 0xC33A0203,
		0x81C, 0xA63C0203,
		0x81C, 0xA53E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0x83480203,
		0x81C, 0x824A0203,
		0x81C, 0x814C0203,
		0x81C, 0x804E0203,
		0x81C, 0x63500203,
		0x81C, 0x62520203,
		0x81C, 0x61540203,
		0x81C, 0x42560203,
		0x81C, 0x41580203,
		0x81C, 0x405A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x20600203,
		0x81C, 0x04620203,
		0x81C, 0x03640203,
		0x81C, 0x02660203,
		0x81C, 0x01680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x9000000d,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xC6340203,
		0x81C, 0xC5360203,
		0x81C, 0xC4380203,
		0x81C, 0xC33A0203,
		0x81C, 0xA63C0203,
		0x81C, 0xA53E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0x83480203,
		0x81C, 0x824A0203,
		0x81C, 0x814C0203,
		0x81C, 0x804E0203,
		0x81C, 0x63500203,
		0x81C, 0x62520203,
		0x81C, 0x61540203,
		0x81C, 0x42560203,
		0x81C, 0x41580203,
		0x81C, 0x405A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x20600203,
		0x81C, 0x04620203,
		0x81C, 0x03640203,
		0x81C, 0x02660203,
		0x81C, 0x01680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0x9000000e,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xC6340203,
		0x81C, 0xC5360203,
		0x81C, 0xC4380203,
		0x81C, 0xC33A0203,
		0x81C, 0xA63C0203,
		0x81C, 0xA53E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0x83480203,
		0x81C, 0x824A0203,
		0x81C, 0x814C0203,
		0x81C, 0x804E0203,
		0x81C, 0x63500203,
		0x81C, 0x62520203,
		0x81C, 0x61540203,
		0x81C, 0x42560203,
		0x81C, 0x41580203,
		0x81C, 0x405A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x20600203,
		0x81C, 0x04620203,
		0x81C, 0x03640203,
		0x81C, 0x02660203,
		0x81C, 0x01680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0xA0000000,	0x00000000,
		0x81C, 0xFD000203,
		0x81C, 0xFC020203,
		0x81C, 0xFB040203,
		0x81C, 0xFA060203,
		0x81C, 0xF9080203,
		0x81C, 0xF80A0203,
		0x81C, 0xF70C0203,
		0x81C, 0xF60E0203,
		0x81C, 0xF5100203,
		0x81C, 0xF4120203,
		0x81C, 0xF3140203,
		0x81C, 0xF2160203,
		0x81C, 0xF1180203,
		0x81C, 0xF01A0203,
		0x81C, 0xEF1C0203,
		0x81C, 0xEE1E0203,
		0x81C, 0xED200203,
		0x81C, 0xEC220203,
		0x81C, 0xEB240203,
		0x81C, 0xEA260203,
		0x81C, 0xE9280203,
		0x81C, 0xE82A0203,
		0x81C, 0xE72C0203,
		0x81C, 0xE62E0203,
		0x81C, 0xE5300203,
		0x81C, 0xE4320203,
		0x81C, 0xE3340203,
		0x81C, 0xC6360203,
		0x81C, 0xC5380203,
		0x81C, 0xC43A0203,
		0x81C, 0xC33C0203,
		0x81C, 0xA63E0203,
		0x81C, 0xA5400203,
		0x81C, 0xA4420203,
		0x81C, 0xA3440203,
		0x81C, 0xA2460203,
		0x81C, 0xA1480203,
		0x81C, 0x834A0203,
		0x81C, 0x824C0203,
		0x81C, 0x814E0203,
		0x81C, 0x64500203,
		0x81C, 0x63520203,
		0x81C, 0x62540203,
		0x81C, 0x61560203,
		0x81C, 0x60580203,
		0x81C, 0x235A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x20600203,
		0x81C, 0x03620203,
		0x81C, 0x02640203,
		0x81C, 0x01660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0xB0000000,	0x00000000,
	0x80000000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000303,
		0x81C, 0xFB020303,
		0x81C, 0xFA040303,
		0x81C, 0xF9060303,
		0x81C, 0xF8080303,
		0x81C, 0xF70A0303,
		0x81C, 0xF60C0303,
		0x81C, 0xF50E0303,
		0x81C, 0xF4100303,
		0x81C, 0xF3120303,
		0x81C, 0xF2140303,
		0x81C, 0xF1160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xE52C0303,
		0x81C, 0xE42E0303,
		0x81C, 0xE3300303,
		0x81C, 0xE2320303,
		0x81C, 0xC6340303,
		0x81C, 0xC5360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xA63C0303,
		0x81C, 0xA53E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x804E0303,
		0x81C, 0x63500303,
		0x81C, 0x62520303,
		0x81C, 0x61540303,
		0x81C, 0x42560303,
		0x81C, 0x41580303,
		0x81C, 0x405A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x20600303,
		0x81C, 0x04620303,
		0x81C, 0x03640303,
		0x81C, 0x02660303,
		0x81C, 0x01680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF7000303,
		0x81C, 0xF6020303,
		0x81C, 0xF5040303,
		0x81C, 0xF4060303,
		0x81C, 0xF3080303,
		0x81C, 0xF20A0303,
		0x81C, 0xF10C0303,
		0x81C, 0xF00E0303,
		0x81C, 0xEF100303,
		0x81C, 0xEE120303,
		0x81C, 0xED140303,
		0x81C, 0xEC160303,
		0x81C, 0xEB180303,
		0x81C, 0xEA1A0303,
		0x81C, 0xE91C0303,
		0x81C, 0xCA1E0303,
		0x81C, 0xC9200303,
		0x81C, 0xC8220303,
		0x81C, 0xC7240303,
		0x81C, 0xC6260303,
		0x81C, 0xC5280303,
		0x81C, 0xC42A0303,
		0x81C, 0xC32C0303,
		0x81C, 0xC22E0303,
		0x81C, 0xC1300303,
		0x81C, 0xA4320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0xA03A0303,
		0x81C, 0x823C0303,
		0x81C, 0x813E0303,
		0x81C, 0x80400303,
		0x81C, 0x64420303,
		0x81C, 0x63440303,
		0x81C, 0x62460303,
		0x81C, 0x61480303,
		0x81C, 0x604A0303,
		0x81C, 0x414C0303,
		0x81C, 0x404E0303,
		0x81C, 0x06500303,
		0x81C, 0x05520303,
		0x81C, 0x04540303,
		0x81C, 0x03560303,
		0x81C, 0x02580303,
		0x81C, 0x015A0303,
		0x81C, 0x005C0303,
		0x81C, 0x005E0303,
		0x81C, 0x00600303,
		0x81C, 0x00620303,
		0x81C, 0x00640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF7000303,
		0x81C, 0xF6020303,
		0x81C, 0xF5040303,
		0x81C, 0xF4060303,
		0x81C, 0xF3080303,
		0x81C, 0xF20A0303,
		0x81C, 0xF10C0303,
		0x81C, 0xF00E0303,
		0x81C, 0xEF100303,
		0x81C, 0xEE120303,
		0x81C, 0xED140303,
		0x81C, 0xEC160303,
		0x81C, 0xEB180303,
		0x81C, 0xEA1A0303,
		0x81C, 0xE91C0303,
		0x81C, 0xCA1E0303,
		0x81C, 0xC9200303,
		0x81C, 0xC8220303,
		0x81C, 0xC7240303,
		0x81C, 0xC6260303,
		0x81C, 0xC5280303,
		0x81C, 0xC42A0303,
		0x81C, 0xC32C0303,
		0x81C, 0xC22E0303,
		0x81C, 0xC1300303,
		0x81C, 0xA4320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0xA03A0303,
		0x81C, 0x823C0303,
		0x81C, 0x813E0303,
		0x81C, 0x80400303,
		0x81C, 0x64420303,
		0x81C, 0x63440303,
		0x81C, 0x62460303,
		0x81C, 0x61480303,
		0x81C, 0x604A0303,
		0x81C, 0x414C0303,
		0x81C, 0x404E0303,
		0x81C, 0x22500303,
		0x81C, 0x21520303,
		0x81C, 0x20540303,
		0x81C, 0x03560303,
		0x81C, 0x02580303,
		0x81C, 0x015A0303,
		0x81C, 0x005C0303,
		0x81C, 0x005E0303,
		0x81C, 0x00600303,
		0x81C, 0x00620303,
		0x81C, 0x00640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000303,
		0x81C, 0xFB020303,
		0x81C, 0xFA040303,
		0x81C, 0xF9060303,
		0x81C, 0xF8080303,
		0x81C, 0xF70A0303,
		0x81C, 0xF60C0303,
		0x81C, 0xF50E0303,
		0x81C, 0xF4100303,
		0x81C, 0xF3120303,
		0x81C, 0xF2140303,
		0x81C, 0xF1160303,
		0x81C, 0xF0180303,
		0x81C, 0xEF1A0303,
		0x81C, 0xEE1C0303,
		0x81C, 0xED1E0303,
		0x81C, 0xEC200303,
		0x81C, 0xEB220303,
		0x81C, 0xEA240303,
		0x81C, 0xE9260303,
		0x81C, 0xE8280303,
		0x81C, 0xE72A0303,
		0x81C, 0xE62C0303,
		0x81C, 0xE52E0303,
		0x81C, 0xE4300303,
		0x81C, 0xE3320303,
		0x81C, 0xE2340303,
		0x81C, 0xC6360303,
		0x81C, 0xC5380303,
		0x81C, 0xC43A0303,
		0x81C, 0xC33C0303,
		0x81C, 0xA63E0303,
		0x81C, 0xA5400303,
		0x81C, 0xA4420303,
		0x81C, 0xA3440303,
		0x81C, 0xA2460303,
		0x81C, 0x84480303,
		0x81C, 0x834A0303,
		0x81C, 0x824C0303,
		0x81C, 0x814E0303,
		0x81C, 0x80500303,
		0x81C, 0x63520303,
		0x81C, 0x62540303,
		0x81C, 0x61560303,
		0x81C, 0x60580303,
		0x81C, 0x225A0303,
		0x81C, 0x055C0303,
		0x81C, 0x045E0303,
		0x81C, 0x03600303,
		0x81C, 0x02620303,
		0x81C, 0x01640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF7000303,
		0x81C, 0xF6020303,
		0x81C, 0xF5040303,
		0x81C, 0xF4060303,
		0x81C, 0xF3080303,
		0x81C, 0xF20A0303,
		0x81C, 0xF10C0303,
		0x81C, 0xF00E0303,
		0x81C, 0xEF100303,
		0x81C, 0xEE120303,
		0x81C, 0xED140303,
		0x81C, 0xEC160303,
		0x81C, 0xEB180303,
		0x81C, 0xEA1A0303,
		0x81C, 0xE91C0303,
		0x81C, 0xCA1E0303,
		0x81C, 0xC9200303,
		0x81C, 0xC8220303,
		0x81C, 0xC7240303,
		0x81C, 0xC6260303,
		0x81C, 0xC5280303,
		0x81C, 0xC42A0303,
		0x81C, 0xC32C0303,
		0x81C, 0xC22E0303,
		0x81C, 0xC1300303,
		0x81C, 0xA4320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0xA03A0303,
		0x81C, 0x823C0303,
		0x81C, 0x813E0303,
		0x81C, 0x80400303,
		0x81C, 0x64420303,
		0x81C, 0x63440303,
		0x81C, 0x62460303,
		0x81C, 0x61480303,
		0x81C, 0x604A0303,
		0x81C, 0x414C0303,
		0x81C, 0x404E0303,
		0x81C, 0x22500303,
		0x81C, 0x21520303,
		0x81C, 0x20540303,
		0x81C, 0x03560303,
		0x81C, 0x02580303,
		0x81C, 0x015A0303,
		0x81C, 0x005C0303,
		0x81C, 0x005E0303,
		0x81C, 0x00600303,
		0x81C, 0x00620303,
		0x81C, 0x00640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000303,
		0x81C, 0xFA020303,
		0x81C, 0xF9040303,
		0x81C, 0xF8060303,
		0x81C, 0xF7080303,
		0x81C, 0xF60A0303,
		0x81C, 0xF50C0303,
		0x81C, 0xF40E0303,
		0x81C, 0xF3100303,
		0x81C, 0xF2120303,
		0x81C, 0xF1140303,
		0x81C, 0xF0160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xE52C0303,
		0x81C, 0xE42E0303,
		0x81C, 0xE3300303,
		0x81C, 0xE2320303,
		0x81C, 0xE1340303,
		0x81C, 0xC5360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xC23C0303,
		0x81C, 0xC13E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x804E0303,
		0x81C, 0x64500303,
		0x81C, 0x63520303,
		0x81C, 0x62540303,
		0x81C, 0x61560303,
		0x81C, 0x60580303,
		0x81C, 0x235A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x20600303,
		0x81C, 0x04620303,
		0x81C, 0x03640303,
		0x81C, 0x02660303,
		0x81C, 0x01680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF9000303,
		0x81C, 0xF8020303,
		0x81C, 0xF7040303,
		0x81C, 0xF6060303,
		0x81C, 0xF5080303,
		0x81C, 0xF40A0303,
		0x81C, 0xF30C0303,
		0x81C, 0xF20E0303,
		0x81C, 0xF1100303,
		0x81C, 0xF0120303,
		0x81C, 0xEF140303,
		0x81C, 0xEE160303,
		0x81C, 0xED180303,
		0x81C, 0xEC1A0303,
		0x81C, 0xEB1C0303,
		0x81C, 0xEA1E0303,
		0x81C, 0xC9200303,
		0x81C, 0xC8220303,
		0x81C, 0xC7240303,
		0x81C, 0xC6260303,
		0x81C, 0xC5280303,
		0x81C, 0xC42A0303,
		0x81C, 0xC32C0303,
		0x81C, 0xC22E0303,
		0x81C, 0xC1300303,
		0x81C, 0xC0320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0xA03A0303,
		0x81C, 0x823C0303,
		0x81C, 0x813E0303,
		0x81C, 0x80400303,
		0x81C, 0x64420303,
		0x81C, 0x63440303,
		0x81C, 0x62460303,
		0x81C, 0x61480303,
		0x81C, 0x604A0303,
		0x81C, 0x414C0303,
		0x81C, 0x404E0303,
		0x81C, 0x22500303,
		0x81C, 0x21520303,
		0x81C, 0x20540303,
		0x81C, 0x03560303,
		0x81C, 0x02580303,
		0x81C, 0x015A0303,
		0x81C, 0x005C0303,
		0x81C, 0x005E0303,
		0x81C, 0x00600303,
		0x81C, 0x00620303,
		0x81C, 0x00640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000303,
		0x81C, 0xF7020303,
		0x81C, 0xF6040303,
		0x81C, 0xF5060303,
		0x81C, 0xF4080303,
		0x81C, 0xF30A0303,
		0x81C, 0xF20C0303,
		0x81C, 0xF10E0303,
		0x81C, 0xF0100303,
		0x81C, 0xEF120303,
		0x81C, 0xEE140303,
		0x81C, 0xED160303,
		0x81C, 0xEC180303,
		0x81C, 0xEB1A0303,
		0x81C, 0xEA1C0303,
		0x81C, 0xE91E0303,
		0x81C, 0xCA200303,
		0x81C, 0xC9220303,
		0x81C, 0xC8240303,
		0x81C, 0xC7260303,
		0x81C, 0xC6280303,
		0x81C, 0xC52A0303,
		0x81C, 0xC42C0303,
		0x81C, 0xC32E0303,
		0x81C, 0xC2300303,
		0x81C, 0xC1320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0xA03A0303,
		0x81C, 0x823C0303,
		0x81C, 0x813E0303,
		0x81C, 0x80400303,
		0x81C, 0x65420303,
		0x81C, 0x64440303,
		0x81C, 0x63460303,
		0x81C, 0x62480303,
		0x81C, 0x614A0303,
		0x81C, 0x424C0303,
		0x81C, 0x414E0303,
		0x81C, 0x40500303,
		0x81C, 0x22520303,
		0x81C, 0x21540303,
		0x81C, 0x20560303,
		0x81C, 0x04580303,
		0x81C, 0x035A0303,
		0x81C, 0x025C0303,
		0x81C, 0x015E0303,
		0x81C, 0x00600303,
		0x81C, 0x00620303,
		0x81C, 0x00640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000303,
		0x81C, 0xFA020303,
		0x81C, 0xF9040303,
		0x81C, 0xF8060303,
		0x81C, 0xF7080303,
		0x81C, 0xF60A0303,
		0x81C, 0xF50C0303,
		0x81C, 0xF40E0303,
		0x81C, 0xF3100303,
		0x81C, 0xF2120303,
		0x81C, 0xF1140303,
		0x81C, 0xF0160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xE52C0303,
		0x81C, 0xE42E0303,
		0x81C, 0xE3300303,
		0x81C, 0xE2320303,
		0x81C, 0xC6340303,
		0x81C, 0xC5360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xC23C0303,
		0x81C, 0xC13E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x804E0303,
		0x81C, 0x63500303,
		0x81C, 0x62520303,
		0x81C, 0x43540303,
		0x81C, 0x42560303,
		0x81C, 0x41580303,
		0x81C, 0x235A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x20600303,
		0x81C, 0x04620303,
		0x81C, 0x03640303,
		0x81C, 0x02660303,
		0x81C, 0x01680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000303,
		0x81C, 0xF7020303,
		0x81C, 0xF6040303,
		0x81C, 0xF5060303,
		0x81C, 0xF4080303,
		0x81C, 0xF30A0303,
		0x81C, 0xF20C0303,
		0x81C, 0xF10E0303,
		0x81C, 0xF0100303,
		0x81C, 0xEF120303,
		0x81C, 0xEE140303,
		0x81C, 0xED160303,
		0x81C, 0xEC180303,
		0x81C, 0xEB1A0303,
		0x81C, 0xEA1C0303,
		0x81C, 0xE91E0303,
		0x81C, 0xCA200303,
		0x81C, 0xC9220303,
		0x81C, 0xC8240303,
		0x81C, 0xC7260303,
		0x81C, 0xC6280303,
		0x81C, 0xC52A0303,
		0x81C, 0xC42C0303,
		0x81C, 0xC32E0303,
		0x81C, 0xC2300303,
		0x81C, 0xC1320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0xA03A0303,
		0x81C, 0x823C0303,
		0x81C, 0x813E0303,
		0x81C, 0x80400303,
		0x81C, 0x65420303,
		0x81C, 0x64440303,
		0x81C, 0x63460303,
		0x81C, 0x62480303,
		0x81C, 0x614A0303,
		0x81C, 0x424C0303,
		0x81C, 0x414E0303,
		0x81C, 0x40500303,
		0x81C, 0x22520303,
		0x81C, 0x21540303,
		0x81C, 0x20560303,
		0x81C, 0x04580303,
		0x81C, 0x035A0303,
		0x81C, 0x025C0303,
		0x81C, 0x015E0303,
		0x81C, 0x00600303,
		0x81C, 0x00620303,
		0x81C, 0x00640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000303,
		0x81C, 0xFB020303,
		0x81C, 0xFA040303,
		0x81C, 0xF9060303,
		0x81C, 0xF8080303,
		0x81C, 0xF70A0303,
		0x81C, 0xF60C0303,
		0x81C, 0xF50E0303,
		0x81C, 0xF4100303,
		0x81C, 0xF3120303,
		0x81C, 0xF2140303,
		0x81C, 0xF1160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xE52C0303,
		0x81C, 0xE42E0303,
		0x81C, 0xE3300303,
		0x81C, 0xE2320303,
		0x81C, 0xC6340303,
		0x81C, 0xC5360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xA63C0303,
		0x81C, 0xA53E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x804E0303,
		0x81C, 0x63500303,
		0x81C, 0x62520303,
		0x81C, 0x61540303,
		0x81C, 0x42560303,
		0x81C, 0x41580303,
		0x81C, 0x405A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x20600303,
		0x81C, 0x04620303,
		0x81C, 0x03640303,
		0x81C, 0x02660303,
		0x81C, 0x01680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF8000303,
		0x81C, 0xF7020303,
		0x81C, 0xF6040303,
		0x81C, 0xF5060303,
		0x81C, 0xF4080303,
		0x81C, 0xF30A0303,
		0x81C, 0xF20C0303,
		0x81C, 0xF10E0303,
		0x81C, 0xF0100303,
		0x81C, 0xEF120303,
		0x81C, 0xEE140303,
		0x81C, 0xED160303,
		0x81C, 0xEC180303,
		0x81C, 0xEB1A0303,
		0x81C, 0xEA1C0303,
		0x81C, 0xE91E0303,
		0x81C, 0xCA200303,
		0x81C, 0xC9220303,
		0x81C, 0xC8240303,
		0x81C, 0xC7260303,
		0x81C, 0xC6280303,
		0x81C, 0xC52A0303,
		0x81C, 0xC42C0303,
		0x81C, 0xC32E0303,
		0x81C, 0xC2300303,
		0x81C, 0xC1320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0xA03A0303,
		0x81C, 0x823C0303,
		0x81C, 0x813E0303,
		0x81C, 0x80400303,
		0x81C, 0x64420303,
		0x81C, 0x63440303,
		0x81C, 0x62460303,
		0x81C, 0x61480303,
		0x81C, 0x604A0303,
		0x81C, 0x234C0303,
		0x81C, 0x224E0303,
		0x81C, 0x21500303,
		0x81C, 0x20520303,
		0x81C, 0x06540303,
		0x81C, 0x05560303,
		0x81C, 0x04580303,
		0x81C, 0x035A0303,
		0x81C, 0x025C0303,
		0x81C, 0x015E0303,
		0x81C, 0x00600303,
		0x81C, 0x00620303,
		0x81C, 0x00640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x9000000c,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000303,
		0x81C, 0xFB020303,
		0x81C, 0xFA040303,
		0x81C, 0xF9060303,
		0x81C, 0xF8080303,
		0x81C, 0xF70A0303,
		0x81C, 0xF60C0303,
		0x81C, 0xF50E0303,
		0x81C, 0xF4100303,
		0x81C, 0xF3120303,
		0x81C, 0xF2140303,
		0x81C, 0xF1160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xE52C0303,
		0x81C, 0xE42E0303,
		0x81C, 0xE3300303,
		0x81C, 0xE2320303,
		0x81C, 0xC6340303,
		0x81C, 0xC5360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xA63C0303,
		0x81C, 0xA53E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x804E0303,
		0x81C, 0x63500303,
		0x81C, 0x62520303,
		0x81C, 0x61540303,
		0x81C, 0x42560303,
		0x81C, 0x41580303,
		0x81C, 0x405A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x20600303,
		0x81C, 0x04620303,
		0x81C, 0x03640303,
		0x81C, 0x02660303,
		0x81C, 0x01680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x9000000d,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000303,
		0x81C, 0xFA020303,
		0x81C, 0xF9040303,
		0x81C, 0xF8060303,
		0x81C, 0xF7080303,
		0x81C, 0xF60A0303,
		0x81C, 0xF50C0303,
		0x81C, 0xF40E0303,
		0x81C, 0xF3100303,
		0x81C, 0xF2120303,
		0x81C, 0xF1140303,
		0x81C, 0xEF160303,
		0x81C, 0xEE180303,
		0x81C, 0xED1A0303,
		0x81C, 0xEC1C0303,
		0x81C, 0xEB1E0303,
		0x81C, 0xEA200303,
		0x81C, 0xE9220303,
		0x81C, 0xE8240303,
		0x81C, 0xE7260303,
		0x81C, 0xE6280303,
		0x81C, 0xE52A0303,
		0x81C, 0xE42C0303,
		0x81C, 0xE32E0303,
		0x81C, 0xE2300303,
		0x81C, 0xE1320303,
		0x81C, 0xC6340303,
		0x81C, 0xC5360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xA63C0303,
		0x81C, 0xA53E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x804E0303,
		0x81C, 0x63500303,
		0x81C, 0x62520303,
		0x81C, 0x61540303,
		0x81C, 0x42560303,
		0x81C, 0x41580303,
		0x81C, 0x405A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x20600303,
		0x81C, 0x04620303,
		0x81C, 0x03640303,
		0x81C, 0x02660303,
		0x81C, 0x01680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0x9000000e,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000303,
		0x81C, 0xFA020303,
		0x81C, 0xF9040303,
		0x81C, 0xF8060303,
		0x81C, 0xF7080303,
		0x81C, 0xF60A0303,
		0x81C, 0xF50C0303,
		0x81C, 0xF40E0303,
		0x81C, 0xF3100303,
		0x81C, 0xF2120303,
		0x81C, 0xF1140303,
		0x81C, 0xEF160303,
		0x81C, 0xEE180303,
		0x81C, 0xED1A0303,
		0x81C, 0xEC1C0303,
		0x81C, 0xEB1E0303,
		0x81C, 0xEA200303,
		0x81C, 0xE9220303,
		0x81C, 0xE8240303,
		0x81C, 0xE7260303,
		0x81C, 0xE6280303,
		0x81C, 0xE52A0303,
		0x81C, 0xE42C0303,
		0x81C, 0xE32E0303,
		0x81C, 0xE2300303,
		0x81C, 0xE1320303,
		0x81C, 0xC6340303,
		0x81C, 0xC5360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xA63C0303,
		0x81C, 0xA53E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x804E0303,
		0x81C, 0x63500303,
		0x81C, 0x62520303,
		0x81C, 0x61540303,
		0x81C, 0x42560303,
		0x81C, 0x41580303,
		0x81C, 0x405A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x20600303,
		0x81C, 0x04620303,
		0x81C, 0x03640303,
		0x81C, 0x02660303,
		0x81C, 0x01680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0xA0000000,	0x00000000,
		0x81C, 0xFC000303,
		0x81C, 0xFB020303,
		0x81C, 0xFA040303,
		0x81C, 0xF9060303,
		0x81C, 0xF8080303,
		0x81C, 0xF70A0303,
		0x81C, 0xF60C0303,
		0x81C, 0xF50E0303,
		0x81C, 0xF4100303,
		0x81C, 0xF3120303,
		0x81C, 0xF2140303,
		0x81C, 0xF1160303,
		0x81C, 0xF0180303,
		0x81C, 0xEF1A0303,
		0x81C, 0xEE1C0303,
		0x81C, 0xED1E0303,
		0x81C, 0xEC200303,
		0x81C, 0xEB220303,
		0x81C, 0xEA240303,
		0x81C, 0xE9260303,
		0x81C, 0xE8280303,
		0x81C, 0xE72A0303,
		0x81C, 0xE62C0303,
		0x81C, 0xE52E0303,
		0x81C, 0xE4300303,
		0x81C, 0xE3320303,
		0x81C, 0xE2340303,
		0x81C, 0xC6360303,
		0x81C, 0xC5380303,
		0x81C, 0xC43A0303,
		0x81C, 0xC33C0303,
		0x81C, 0xA63E0303,
		0x81C, 0xA5400303,
		0x81C, 0xA4420303,
		0x81C, 0xA3440303,
		0x81C, 0xA2460303,
		0x81C, 0x84480303,
		0x81C, 0x834A0303,
		0x81C, 0x824C0303,
		0x81C, 0x814E0303,
		0x81C, 0x80500303,
		0x81C, 0x63520303,
		0x81C, 0x62540303,
		0x81C, 0x61560303,
		0x81C, 0x60580303,
		0x81C, 0x235A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x20600303,
		0x81C, 0x03620303,
		0x81C, 0x02640303,
		0x81C, 0x01660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0xB0000000,	0x00000000,
	0x80000000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000001,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xF5000403,
		0x81C, 0xF4020403,
		0x81C, 0xF3040403,
		0x81C, 0xF2060403,
		0x81C, 0xF1080403,
		0x81C, 0xF00A0403,
		0x81C, 0xEF0C0403,
		0x81C, 0xEE0E0403,
		0x81C, 0xED100403,
		0x81C, 0xEC120403,
		0x81C, 0xEB140403,
		0x81C, 0xEA160403,
		0x81C, 0xE9180403,
		0x81C, 0xE81A0403,
		0x81C, 0xE71C0403,
		0x81C, 0xE61E0403,
		0x81C, 0xE5200403,
		0x81C, 0xE4220403,
		0x81C, 0xE3240403,
		0x81C, 0xE2260403,
		0x81C, 0xE1280403,
		0x81C, 0xE02A0403,
		0x81C, 0xC32C0403,
		0x81C, 0xC22E0403,
		0x81C, 0xC1300403,
		0x81C, 0xC0320403,
		0x81C, 0xA4340403,
		0x81C, 0xA3360403,
		0x81C, 0xA2380403,
		0x81C, 0xA13A0403,
		0x81C, 0xA03C0403,
		0x81C, 0x823E0403,
		0x81C, 0x81400403,
		0x81C, 0x80420403,
		0x81C, 0x64440403,
		0x81C, 0x63460403,
		0x81C, 0x62480403,
		0x81C, 0x614A0403,
		0x81C, 0x604C0403,
		0x81C, 0x454E0403,
		0x81C, 0x44500403,
		0x81C, 0x43520403,
		0x81C, 0x42540403,
		0x81C, 0x41560403,
		0x81C, 0x40580403,
		0x81C, 0x055A0403,
		0x81C, 0x045C0403,
		0x81C, 0x035E0403,
		0x81C, 0x02600403,
		0x81C, 0x01620403,
		0x81C, 0x00640403,
		0x81C, 0x00660403,
		0x81C, 0x00680403,
		0x81C, 0x006A0403,
		0x81C, 0x006C0403,
		0x81C, 0x006E0403,
		0x81C, 0x00700403,
		0x81C, 0x00720403,
		0x81C, 0x00740403,
		0x81C, 0x00760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000003,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xF6000403,
		0x81C, 0xF5020403,
		0x81C, 0xF4040403,
		0x81C, 0xF3060403,
		0x81C, 0xF2080403,
		0x81C, 0xF10A0403,
		0x81C, 0xF00C0403,
		0x81C, 0xEF0E0403,
		0x81C, 0xD6100403,
		0x81C, 0xD5120403,
		0x81C, 0xD4140403,
		0x81C, 0xD3160403,
		0x81C, 0xD2180403,
		0x81C, 0xD11A0403,
		0x81C, 0xD01C0403,
		0x81C, 0xCF1E0403,
		0x81C, 0x95200403,
		0x81C, 0x94220403,
		0x81C, 0x93240403,
		0x81C, 0x92260403,
		0x81C, 0x91280403,
		0x81C, 0x902A0403,
		0x81C, 0x8F2C0403,
		0x81C, 0x8E2E0403,
		0x81C, 0x8D300403,
		0x81C, 0x8C320403,
		0x81C, 0x8B340403,
		0x81C, 0x8A360403,
		0x81C, 0x89380403,
		0x81C, 0x883A0403,
		0x81C, 0x873C0403,
		0x81C, 0x863E0403,
		0x81C, 0x68400403,
		0x81C, 0x67420403,
		0x81C, 0x66440403,
		0x81C, 0x65460403,
		0x81C, 0x64480403,
		0x81C, 0x634A0403,
		0x81C, 0x484C0403,
		0x81C, 0x474E0403,
		0x81C, 0x46500403,
		0x81C, 0x45520403,
		0x81C, 0x44540403,
		0x81C, 0x27560403,
		0x81C, 0x26580403,
		0x81C, 0x255A0403,
		0x81C, 0x245C0403,
		0x81C, 0x235E0403,
		0x81C, 0x04600403,
		0x81C, 0x03620403,
		0x81C, 0x02640403,
		0x81C, 0x01660403,
		0x81C, 0x00680403,
		0x81C, 0x006A0403,
		0x81C, 0x006C0403,
		0x81C, 0x006E0403,
		0x81C, 0x00700403,
		0x81C, 0x00720403,
		0x81C, 0x00740403,
		0x81C, 0x00760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000006,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xF5000403,
		0x81C, 0xF4020403,
		0x81C, 0xF3040403,
		0x81C, 0xF2060403,
		0x81C, 0xF1080403,
		0x81C, 0xF00A0403,
		0x81C, 0xEF0C0403,
		0x81C, 0xEE0E0403,
		0x81C, 0xED100403,
		0x81C, 0xEC120403,
		0x81C, 0xEB140403,
		0x81C, 0xEA160403,
		0x81C, 0xE9180403,
		0x81C, 0xE81A0403,
		0x81C, 0xE71C0403,
		0x81C, 0xE61E0403,
		0x81C, 0xE5200403,
		0x81C, 0xE4220403,
		0x81C, 0xE3240403,
		0x81C, 0xE2260403,
		0x81C, 0xE1280403,
		0x81C, 0xE02A0403,
		0x81C, 0xC32C0403,
		0x81C, 0xC22E0403,
		0x81C, 0xC1300403,
		0x81C, 0xC0320403,
		0x81C, 0xA4340403,
		0x81C, 0xA3360403,
		0x81C, 0xA2380403,
		0x81C, 0xA13A0403,
		0x81C, 0xA03C0403,
		0x81C, 0x823E0403,
		0x81C, 0x81400403,
		0x81C, 0x80420403,
		0x81C, 0x64440403,
		0x81C, 0x63460403,
		0x81C, 0x62480403,
		0x81C, 0x614A0403,
		0x81C, 0x604C0403,
		0x81C, 0x454E0403,
		0x81C, 0x44500403,
		0x81C, 0x43520403,
		0x81C, 0x42540403,
		0x81C, 0x41560403,
		0x81C, 0x40580403,
		0x81C, 0x055A0403,
		0x81C, 0x045C0403,
		0x81C, 0x035E0403,
		0x81C, 0x02600403,
		0x81C, 0x01620403,
		0x81C, 0x00640403,
		0x81C, 0x00660403,
		0x81C, 0x00680403,
		0x81C, 0x006A0403,
		0x81C, 0x006C0403,
		0x81C, 0x006E0403,
		0x81C, 0x00700403,
		0x81C, 0x00720403,
		0x81C, 0x00740403,
		0x81C, 0x00760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000007,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xF5000403,
		0x81C, 0xF4020403,
		0x81C, 0xF3040403,
		0x81C, 0xF2060403,
		0x81C, 0xF1080403,
		0x81C, 0xF00A0403,
		0x81C, 0xEF0C0403,
		0x81C, 0xEE0E0403,
		0x81C, 0xED100403,
		0x81C, 0xEC120403,
		0x81C, 0xEB140403,
		0x81C, 0xEA160403,
		0x81C, 0xE9180403,
		0x81C, 0xE81A0403,
		0x81C, 0xE71C0403,
		0x81C, 0xE61E0403,
		0x81C, 0xE5200403,
		0x81C, 0xE4220403,
		0x81C, 0xE3240403,
		0x81C, 0xE2260403,
		0x81C, 0xE1280403,
		0x81C, 0xE02A0403,
		0x81C, 0xC32C0403,
		0x81C, 0xC22E0403,
		0x81C, 0xC1300403,
		0x81C, 0xC0320403,
		0x81C, 0xA4340403,
		0x81C, 0xA3360403,
		0x81C, 0xA2380403,
		0x81C, 0xA13A0403,
		0x81C, 0xA03C0403,
		0x81C, 0x823E0403,
		0x81C, 0x81400403,
		0x81C, 0x80420403,
		0x81C, 0x64440403,
		0x81C, 0x63460403,
		0x81C, 0x62480403,
		0x81C, 0x614A0403,
		0x81C, 0x604C0403,
		0x81C, 0x454E0403,
		0x81C, 0x44500403,
		0x81C, 0x43520403,
		0x81C, 0x42540403,
		0x81C, 0x41560403,
		0x81C, 0x40580403,
		0x81C, 0x055A0403,
		0x81C, 0x045C0403,
		0x81C, 0x035E0403,
		0x81C, 0x02600403,
		0x81C, 0x01620403,
		0x81C, 0x00640403,
		0x81C, 0x00660403,
		0x81C, 0x00680403,
		0x81C, 0x006A0403,
		0x81C, 0x006C0403,
		0x81C, 0x006E0403,
		0x81C, 0x00700403,
		0x81C, 0x00720403,
		0x81C, 0x00740403,
		0x81C, 0x00760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000008,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x90000009,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xF5000403,
		0x81C, 0xF4020403,
		0x81C, 0xF3040403,
		0x81C, 0xF2060403,
		0x81C, 0xF1080403,
		0x81C, 0xF00A0403,
		0x81C, 0xEF0C0403,
		0x81C, 0xEE0E0403,
		0x81C, 0xED100403,
		0x81C, 0xEC120403,
		0x81C, 0xEB140403,
		0x81C, 0xEA160403,
		0x81C, 0xE9180403,
		0x81C, 0xE81A0403,
		0x81C, 0xE71C0403,
		0x81C, 0xE61E0403,
		0x81C, 0xE5200403,
		0x81C, 0xE4220403,
		0x81C, 0xE3240403,
		0x81C, 0xE2260403,
		0x81C, 0xE1280403,
		0x81C, 0xE02A0403,
		0x81C, 0xC32C0403,
		0x81C, 0xC22E0403,
		0x81C, 0xC1300403,
		0x81C, 0xC0320403,
		0x81C, 0xA4340403,
		0x81C, 0xA3360403,
		0x81C, 0xA2380403,
		0x81C, 0xA13A0403,
		0x81C, 0xA03C0403,
		0x81C, 0x823E0403,
		0x81C, 0x81400403,
		0x81C, 0x80420403,
		0x81C, 0x64440403,
		0x81C, 0x63460403,
		0x81C, 0x62480403,
		0x81C, 0x614A0403,
		0x81C, 0x604C0403,
		0x81C, 0x454E0403,
		0x81C, 0x44500403,
		0x81C, 0x43520403,
		0x81C, 0x42540403,
		0x81C, 0x41560403,
		0x81C, 0x40580403,
		0x81C, 0x055A0403,
		0x81C, 0x045C0403,
		0x81C, 0x035E0403,
		0x81C, 0x02600403,
		0x81C, 0x01620403,
		0x81C, 0x00640403,
		0x81C, 0x00660403,
		0x81C, 0x00680403,
		0x81C, 0x006A0403,
		0x81C, 0x006C0403,
		0x81C, 0x006E0403,
		0x81C, 0x00700403,
		0x81C, 0x00720403,
		0x81C, 0x00740403,
		0x81C, 0x00760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x9000000a,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x9000000b,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xF5000403,
		0x81C, 0xF4020403,
		0x81C, 0xF3040403,
		0x81C, 0xF2060403,
		0x81C, 0xF1080403,
		0x81C, 0xF00A0403,
		0x81C, 0xEF0C0403,
		0x81C, 0xEE0E0403,
		0x81C, 0xED100403,
		0x81C, 0xEC120403,
		0x81C, 0xEB140403,
		0x81C, 0xEA160403,
		0x81C, 0xE9180403,
		0x81C, 0xE81A0403,
		0x81C, 0xE71C0403,
		0x81C, 0xE61E0403,
		0x81C, 0xE5200403,
		0x81C, 0xE4220403,
		0x81C, 0xE3240403,
		0x81C, 0xE2260403,
		0x81C, 0xE1280403,
		0x81C, 0xE02A0403,
		0x81C, 0xC32C0403,
		0x81C, 0xC22E0403,
		0x81C, 0xC1300403,
		0x81C, 0xC0320403,
		0x81C, 0xA4340403,
		0x81C, 0xA3360403,
		0x81C, 0xA2380403,
		0x81C, 0xA13A0403,
		0x81C, 0xA03C0403,
		0x81C, 0x823E0403,
		0x81C, 0x81400403,
		0x81C, 0x80420403,
		0x81C, 0x64440403,
		0x81C, 0x63460403,
		0x81C, 0x62480403,
		0x81C, 0x614A0403,
		0x81C, 0x604C0403,
		0x81C, 0x454E0403,
		0x81C, 0x44500403,
		0x81C, 0x43520403,
		0x81C, 0x42540403,
		0x81C, 0x41560403,
		0x81C, 0x40580403,
		0x81C, 0x055A0403,
		0x81C, 0x045C0403,
		0x81C, 0x035E0403,
		0x81C, 0x02600403,
		0x81C, 0x01620403,
		0x81C, 0x00640403,
		0x81C, 0x00660403,
		0x81C, 0x00680403,
		0x81C, 0x006A0403,
		0x81C, 0x006C0403,
		0x81C, 0x006E0403,
		0x81C, 0x00700403,
		0x81C, 0x00720403,
		0x81C, 0x00740403,
		0x81C, 0x00760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x9000000c,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x9000000d,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0x9000000e,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000403,
		0x81C, 0xFF000403,
		0x81C, 0xFF020403,
		0x81C, 0xFE040403,
		0x81C, 0xFD060403,
		0x81C, 0xFC080403,
		0x81C, 0xFB0A0403,
		0x81C, 0xFA0C0403,
		0x81C, 0xF90E0403,
		0x81C, 0xF8100403,
		0x81C, 0xF7120403,
		0x81C, 0xF6140403,
		0x81C, 0xF5160403,
		0x81C, 0xF4180403,
		0x81C, 0xF31A0403,
		0x81C, 0xF21C0403,
		0x81C, 0xD51E0403,
		0x81C, 0xD4200403,
		0x81C, 0xD3220403,
		0x81C, 0xD2240403,
		0x81C, 0xB6260403,
		0x81C, 0xB5280403,
		0x81C, 0xB42A0403,
		0x81C, 0xB32C0403,
		0x81C, 0xB22E0403,
		0x81C, 0xB1300403,
		0x81C, 0xB0320403,
		0x81C, 0xAF340403,
		0x81C, 0xAE360403,
		0x81C, 0xAD380403,
		0x81C, 0xAC3A0403,
		0x81C, 0xAB3C0403,
		0x81C, 0xAA3E0403,
		0x81C, 0xA9400403,
		0x81C, 0xA8420403,
		0x81C, 0xA7440403,
		0x81C, 0xA6460403,
		0x81C, 0xA5480403,
		0x81C, 0xA44A0403,
		0x81C, 0xA34C0403,
		0x81C, 0x854E0403,
		0x81C, 0x84500403,
		0x81C, 0x83520403,
		0x81C, 0x82540403,
		0x81C, 0x81560403,
		0x81C, 0x80580403,
		0x81C, 0x485A0403,
		0x81C, 0x475C0403,
		0x81C, 0x465E0403,
		0x81C, 0x45600403,
		0x81C, 0x44620403,
		0x81C, 0x0A640403,
		0x81C, 0x09660403,
		0x81C, 0x08680403,
		0x81C, 0x076A0403,
		0x81C, 0x066C0403,
		0x81C, 0x056E0403,
		0x81C, 0x04700403,
		0x81C, 0x03720403,
		0x81C, 0x02740403,
		0x81C, 0x01760403,
		0x81C, 0x00780403,
		0x81C, 0x007A0403,
		0x81C, 0x007C0403,
		0x81C, 0x007E0403,
	0xB0000000,	0x00000000,
	0x80000000,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
		0xE50, 0x00000022,
		0xE50, 0x00000020,
	0x9000000d,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
		0xE50, 0x00000022,
		0xE50, 0x00000020,
	0x9000000e,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
		0xE50, 0x00000022,
		0xE50, 0x00000020,
	0xA0000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
		0xE50, 0x00000022,
		0xE50, 0x00000020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8822b_agc_tab(
	struct	PHY_DM_STRUCT *p_dm_odm
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8822b_agc_tab)/sizeof(u32);
	u32	*array = array_mp_8822b_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8822b_agc_tab\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8822b(p_dm_odm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8822b_agc_tab(void)
{
		return 85;
}

/******************************************************************************
*                           phy_reg.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg[] = {
		0x800, 0x9020D010,
		0x804, 0x800181A0,
		0x808, 0x0E028233,
		0x80C, 0x10000013,
		0x810, 0x21101243,
		0x814, 0x020C3D10,
		0x818, 0x84A10385,
		0x81C, 0x1E1E081F,
		0x820, 0x0001AAAA,
		0x824, 0x00030FE0,
		0x828, 0x0000CCCC,
		0x82C, 0x75CB7010,
		0x830, 0x79A0EA2A,
		0x834, 0x072E6986,
		0x838, 0x87766441,
		0x83C, 0x9194B2B7,
		0x840, 0x171750E0,
		0x844, 0x4C3D7CDB,
		0x848, 0x4AD0408B,
		0x84C, 0x6AFBF7A5,
		0x850, 0x28A74706,
		0x854, 0x0001520C,
		0x858, 0x4060C000,
		0x85C, 0x74010160,
		0x860, 0x68A7C321,
		0x864, 0x79F27432,
		0x868, 0x8CA7A314,
		0x86C, 0x778C2878,
		0x870, 0x77777777,
		0x874, 0x27612C2E,
		0x878, 0xC0003152,
		0x87C, 0x5C8FC000,
		0x880, 0x00000000,
		0x884, 0x00000000,
		0x888, 0x00000000,
		0x88C, 0x00000000,
		0x890, 0x00000000,
		0x894, 0x00000000,
		0x898, 0x00000000,
		0x89C, 0x00000000,
		0x8A0, 0x00000013,
		0x8A4, 0x7F7F7F7F,
		0x8A8, 0x2202033E,
		0x8AC, 0xF00F000A,
		0x8B0, 0x00000600,
		0x8B4, 0x000FC080,
		0x8B8, 0xEC0057F7,
		0x8BC, 0xACB520A3,
		0x8C0, 0xFFE04020,
		0x8C4, 0x47C00000,
		0x8C8, 0x000251A5,
		0x8CC, 0x08108492,
		0x8D0, 0x0000B800,
		0x8D4, 0x860308A0,
		0x8D8, 0x29095612,
		0x8DC, 0x00000000,
		0x8E0, 0x32D16777,
		0x8E4, 0x4C098935,
		0x8E8, 0xFFFFC42C,
		0x8EC, 0x99999999,
		0x8F0, 0x00009999,
		0x8F4, 0x00D80FA1,
		0x8F8, 0x40000080,
		0x8FC, 0x00000130,
		0x900, 0x00800000,
		0x904, 0x00000000,
		0x908, 0x00000000,
		0x90C, 0xD3000000,
		0x910, 0x0000FC00,
		0x914, 0xC6380000,
		0x918, 0x1C1028C0,
		0x91C, 0x64B11A1C,
		0x920, 0xE0767233,
		0x924, 0x855A2500,
		0x928, 0x4AB0E4E4,
		0x92C, 0xFFFEB200,
		0x930, 0xFFFFFFFE,
		0x934, 0x001FFFFF,
		0x938, 0x00008480,
		0x93C, 0xE41C0642,
		0x940, 0x0E470430,
		0x944, 0x00000000,
		0x948, 0xAC000000,
		0x94C, 0x10000083,
		0x950, 0x32010080,
		0x954, 0x84510080,
		0x958, 0x00000001,
		0x95C, 0x04248000,
		0x960, 0x00000000,
		0x964, 0x00000000,
		0x968, 0x00000000,
		0x96C, 0x00000000,
		0x970, 0x00001FFF,
		0x974, 0x44000FFF,
		0x978, 0x00000000,
		0x97C, 0x00000000,
		0x980, 0x00000000,
		0x984, 0x00000000,
		0x988, 0x00000000,
		0x98C, 0x43440000,
		0x990, 0x27100000,
		0x994, 0xFFFF0100,
		0x998, 0xFFFFFF5C,
		0x99C, 0xFFFFFFFF,
		0x9A0, 0x000000FF,
		0x9A4, 0x80000088,
		0x9A8, 0x0C2F0000,
		0x9AC, 0x01560000,
		0x9B0, 0x70000000,
		0x9B4, 0x00000000,
		0x9B8, 0x00000000,
		0x9BC, 0x00000000,
		0x9C0, 0x00000000,
		0x9C4, 0x00000000,
		0x9C8, 0x00000000,
		0x9CC, 0x00000000,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000000,
		0x9E4, 0x02000402,
		0x9E8, 0x000022D4,
		0x9EC, 0x00000000,
		0x9F0, 0x00010080,
		0x9F4, 0x00000000,
		0x9F8, 0x00000000,
		0x9FC, 0xEFFFF7F7,
		0xA00, 0x00D047C8,
		0xA04, 0x81FF800C,
		0xA08, 0x8C838300,
		0xA0C, 0x2E20100F,
		0xA10, 0x9500BB78,
		0xA14, 0x1114D028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0x84880000,
		0xA24, 0x384F6577,
		0xA28, 0x00001525,
		0xA2C, 0x00920000,
		0xA70, 0x101FFF00,
		0xA74, 0x00000148,
		0xA78, 0x00000900,
		0xA7C, 0x225B0606,
		0xA80, 0x218675B2,
		0xA84, 0x80208C00,
		0xA88, 0x040C0000,
		0xA8C, 0x12345678,
		0xA90, 0xABCDEF00,
		0xA94, 0x001B1B89,
		0xA98, 0x030A0000,
		0xA9C, 0x00060000,
		0xAA0, 0x00000000,
		0xAA4, 0x0004000F,
		0xAA8, 0x00000200,
		0xB00, 0xE1000440,
		0xB04, 0x00800000,
		0xB08, 0xFF02030B,
		0xB0C, 0x01EAA406,
		0xB10, 0x00030690,
		0xB14, 0x006000FA,
		0xB18, 0x00000002,
		0xB1C, 0x00000002,
		0xB20, 0x4B00001F,
		0xB24, 0x4E8E3E40,
		0xB28, 0x03020100,
		0xB2C, 0x07060504,
		0xB30, 0x0B0A0908,
		0xB34, 0x0F0E0D0C,
		0xB38, 0x13121110,
		0xB3C, 0x0000003A,
		0xB40, 0x00000000,
		0xB44, 0x80000000,
		0xB48, 0x3F0000FA,
		0xB4C, 0x88C80020,
		0xB50, 0x00000000,
		0xB54, 0x00004241,
		0xB58, 0xE0008208,
		0xB5C, 0x41EFFFF9,
		0xB60, 0x00000000,
		0xB64, 0x00200063,
		0xB68, 0x0000003A,
		0xB6C, 0x00000102,
		0xB70, 0x4E6D1870,
		0xB74, 0x03020100,
		0xB78, 0x07060504,
		0xB7C, 0x0B0A0908,
		0xB80, 0x0F0E0D0C,
		0xB84, 0x13121110,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xC00, 0x00000007,
		0xC04, 0x00240020,
		0xC08, 0x60403231,
		0xC0C, 0x00012345,
		0xC10, 0x00000100,
		0xC14, 0x01000000,
		0xC18, 0x00000000,
		0xC1C, 0x40040053,
		0xC20, 0x40020103,
		0xC24, 0x00000000,
		0xC28, 0x00000000,
		0xC2C, 0x00000000,
		0xC30, 0x00000000,
		0xC34, 0x00000000,
		0xC38, 0x00000000,
		0xC3C, 0x00000000,
		0xC40, 0x00000000,
		0xC44, 0x00000000,
		0xC48, 0x00000000,
		0xC4C, 0x00000000,
		0xC50, 0x00000020,
		0xC54, 0x00000000,
		0xC58, 0xD8020402,
		0xC5C, 0xDE000120,
		0xC68, 0x5979993F,
		0xC6C, 0x0000122A,
		0xC70, 0x99795979,
		0xC74, 0x99795979,
		0xC78, 0x99799979,
		0xC7C, 0x99791979,
		0xC80, 0x19791979,
		0xC84, 0x19791979,
		0xC88, 0x00000000,
		0xC8C, 0x07000000,
		0xC94, 0x01000100,
		0xC98, 0x201C8000,
		0xC9C, 0x00000000,
		0xCA0, 0x0000A555,
		0xCA4, 0x08040201,
		0xCA8, 0x80402010,
		0xCAC, 0x00000000,
		0xCB0, 0x77777777,
		0xCB4, 0x00007777,
		0xCB8, 0x00000000,
		0xCBC, 0x00000000,
		0xCC0, 0x00000000,
		0xCC4, 0x00000000,
		0xCC8, 0x00000000,
		0xCCC, 0x00000000,
		0xCD0, 0x00000000,
		0xCD4, 0x00000000,
		0xCD8, 0x00000000,
		0xCDC, 0x00000000,
		0xCE0, 0x00000000,
		0xCE4, 0x00000000,
		0xCE8, 0x00000000,
		0xCEC, 0x00000000,
		0xE00, 0x00000007,
		0xE04, 0x00240020,
		0xE08, 0x60403231,
		0xE0C, 0x00012345,
		0xE10, 0x00000100,
		0xE14, 0x01000000,
		0xE18, 0x00000000,
		0xE1C, 0x40040053,
		0xE20, 0x40020103,
		0xE24, 0x00000000,
		0xE28, 0x00000000,
		0xE2C, 0x00000000,
		0xE30, 0x00000000,
		0xE34, 0x00000000,
		0xE38, 0x00000000,
		0xE3C, 0x00000000,
		0xE40, 0x00000000,
		0xE44, 0x00000000,
		0xE48, 0x00000000,
		0xE4C, 0x00000000,
		0xE50, 0x00000020,
		0xE54, 0x00000000,
		0xE58, 0xD8020402,
		0xE5C, 0xDE000120,
		0xE68, 0x5979993F,
		0xE6C, 0x0000122A,
		0xE70, 0x99795979,
		0xE74, 0x99795979,
		0xE78, 0x99799979,
		0xE7C, 0x99791979,
		0xE80, 0x19791979,
		0xE84, 0x19791979,
		0xE88, 0x00000000,
		0xE8C, 0x07000000,
		0xE94, 0x01000100,
		0xE98, 0x201C8000,
		0xE9C, 0x00000000,
		0xEA0, 0x0000A555,
		0xEA4, 0x08040201,
		0xEA8, 0x80402010,
		0xEAC, 0x00000000,
		0xEB0, 0x77777777,
		0xEB4, 0x00007777,
		0xEB8, 0x00000000,
		0xEBC, 0x00000000,
		0xEC0, 0x00000000,
		0xEC4, 0x00000000,
		0xEC8, 0x00000000,
		0xECC, 0x00000000,
		0xED0, 0x00000000,
		0xED4, 0x00000000,
		0xED8, 0x00000000,
		0xEDC, 0x00000000,
		0xEE0, 0x00000000,
		0xEE4, 0x00000000,
		0xEE8, 0x00000000,
		0xEEC, 0x00000000,
		0x1900, 0x00000000,
		0x1904, 0x00238000,
		0x1908, 0x00000000,
		0x190C, 0x00000000,
		0x1910, 0x00000000,
		0x1914, 0x00000000,
		0x1918, 0x00000000,
		0x191C, 0x00000000,
		0x1920, 0x00000000,
		0x1924, 0x00000000,
		0x1928, 0x00000000,
		0x192C, 0x00000000,
		0x1930, 0x00000000,
		0x1934, 0x00000000,
		0x1938, 0x00000000,
		0x193C, 0x00000000,
		0x1940, 0x00000000,
		0x1944, 0x00000000,
		0x1948, 0x00000000,
		0x194C, 0x00000000,
		0x1950, 0x00000000,
		0x1954, 0x00000000,
		0x1958, 0x00000000,
		0x195C, 0x00000000,
		0x1960, 0x00000000,
		0x1964, 0x00000000,
		0x1968, 0x00000000,
		0x196C, 0x00000000,
		0x1970, 0x00000000,
		0x1974, 0x00000000,
		0x1978, 0x00000000,
		0x197C, 0x00000000,
		0x1980, 0x00000000,
		0x1984, 0x03000000,
		0x1988, 0x21401E88,
		0x198C, 0x00004000,
		0x1990, 0x00000000,
		0x1994, 0x00000000,
		0x1998, 0x00000053,
		0x199C, 0x00000000,
		0x19A0, 0x00000000,
		0x19A4, 0x00000000,
		0x19A8, 0x00000000,
		0x19AC, 0x0E47E47F,
		0x19B0, 0x00000000,
		0x19B4, 0x0E47E47F,
		0x19B8, 0x00000000,
		0x19BC, 0x00000000,
		0x19C0, 0x00000000,
		0x19C4, 0x00000000,
		0x19C8, 0x00000000,
		0x19CC, 0x00000000,
		0x19D0, 0x00000000,
		0x19D4, 0xAAAAAAAA,
		0x19D8, 0x00000AAA,
		0x19DC, 0x133E0F37,
		0x19E0, 0x00000000,
		0x19E4, 0x00000000,
		0x19E8, 0x00000000,
		0x19EC, 0x00000000,
		0x19F0, 0x00000000,
		0x19F4, 0x00000000,
		0x19F8, 0x01A00000,
		0x19FC, 0x00000000,
		0x1C00, 0x00000100,
		0x1C04, 0x01000000,
		0x1C08, 0x00000100,
		0x1C0C, 0x01000000,
		0x1C10, 0x00000100,
		0x1C14, 0x01000000,
		0x1C18, 0x00000100,
		0x1C1C, 0x01000000,
		0x1C20, 0x00000100,
		0x1C24, 0x01000000,
		0x1C28, 0x00000100,
		0x1C2C, 0x01000000,
		0x1C30, 0x00000100,
		0x1C34, 0x01000000,
		0x1C38, 0x00000000,
		0x1C3C, 0x00000000,
		0x1C40, 0x000C0100,
		0x1C44, 0x000000F3,
		0x1C48, 0x1A8249A8,
		0x1C4C, 0x1461C826,
		0x1C50, 0x0001469E,
		0x1C54, 0x58D158D1,
		0x1C58, 0x04490088,
		0x1C5C, 0x04004400,
		0x1C60, 0x00000000,
		0x1C64, 0x04004400,
		0x1C68, 0x00000100,
		0x1C6C, 0x01000000,
		0x1C70, 0x00000100,
		0x1C74, 0x01000000,
		0x1C78, 0x00000000,
		0x1C7C, 0x00000010,
		0x1C80, 0x5FFF5FFF,
		0x1C84, 0x5FFF5FFF,
		0x1C88, 0x5FFF5FFF,
		0x1C8C, 0x5FFF5FFF,
		0x1C90, 0x5FFF5FFF,
		0x1C94, 0x5FFF5FFF,
		0x1C98, 0x5FFF5FFF,
		0x1C9C, 0x5FFF5FFF,
		0x1CA0, 0x00000100,
		0x1CA4, 0x01000000,
		0x1CA8, 0x00000100,
		0x1CAC, 0x5FFF5FFF,
		0x1CB0, 0x00000100,
		0x1CB4, 0x01000000,
		0x1CB8, 0x00000000,
		0x1CBC, 0x00000000,
		0x1CC0, 0x00000100,
		0x1CC4, 0x01000000,
		0x1CC8, 0x00000100,
		0x1CCC, 0x01000000,
		0x1CD0, 0x00000100,
		0x1CD4, 0x01000000,
		0x1CD8, 0x00000100,
		0x1CDC, 0x01000000,
		0x1CE0, 0x00000100,
		0x1CE4, 0x01000000,
		0x1CE8, 0x00000100,
		0x1CEC, 0x01000000,
		0x1CF0, 0x00000100,
		0x1CF4, 0x01000000,
		0x1CF8, 0x00000000,
		0x1CFC, 0x00000000,
		0xC60, 0x70038040,
		0xC60, 0x70038040,
		0xC60, 0x70146040,
		0xC60, 0x70246040,
		0xC60, 0x70346040,
		0xC60, 0x70446040,
		0xC60, 0x70532040,
		0xC60, 0x70646040,
		0xC60, 0x70738040,
		0xC60, 0x70838040,
		0xC60, 0x70938040,
		0xC60, 0x70A38040,
		0xC60, 0x70B36040,
		0xC60, 0x70C06040,
		0xC60, 0x70D06040,
		0xC60, 0x70E76040,
		0xC60, 0x70F06040,
		0xE60, 0x70038040,
		0xE60, 0x70038040,
		0xE60, 0x70146040,
		0xE60, 0x70246040,
		0xE60, 0x70346040,
		0xE60, 0x70446040,
		0xE60, 0x70532040,
		0xE60, 0x70646040,
		0xE60, 0x70738040,
		0xE60, 0x70838040,
		0xE60, 0x70938040,
		0xE60, 0x70A38040,
		0xE60, 0x70B36040,
		0xE60, 0x70C06040,
		0xE60, 0x70D06040,
		0xE60, 0x70E76040,
		0xE60, 0x70F06040,
		0xC64, 0x00800000,
		0xC64, 0x08800001,
		0xC64, 0x00800002,
		0xC64, 0x00800003,
		0xC64, 0x00800004,
		0xC64, 0x00800005,
		0xC64, 0x00800006,
		0xC64, 0x08800007,
		0xC64, 0x00004000,
		0xE64, 0x00800000,
		0xE64, 0x08800001,
		0xE64, 0x00800002,
		0xE64, 0x00800003,
		0xE64, 0x00800004,
		0xE64, 0x00800005,
		0xE64, 0x00800006,
		0xE64, 0x08800007,
		0xE64, 0x00004000,
		0x1B00, 0xF8000008,
		0x1B00, 0xF80A7008,
		0x1B00, 0xF8015008,
		0x1B00, 0xF8000008,
		0x1B04, 0xE24629D2,
		0x1B08, 0x00000080,
		0x1B0C, 0x00000000,
		0x1B10, 0x00011C00,
		0x1B14, 0x00000000,
		0x1B18, 0x00292903,
		0x1B1C, 0xA2193C32,
		0x1B20, 0x01840008,
		0x1B24, 0x01860008,
		0x1B28, 0x80060300,
		0x1B2C, 0x00000003,
		0x1B30, 0x20000000,
		0x1B34, 0x00000800,
		0x1B3C, 0x20000000,
		0x1BC0, 0x01000000,
		0x1BCC, 0x00000000,
		0x1B00, 0xF800000A,
		0x1B1C, 0xA2193C32,
		0x1B20, 0x01840008,
		0x1B24, 0x01860008,
		0x1B28, 0x80060300,
		0x1B2C, 0x00000003,
		0x1B30, 0x20000000,
		0x1B34, 0x00000800,
		0x1B3C, 0x20000000,
		0x1BC0, 0x01000000,
		0x1BCC, 0x00000000,
		0x1B00, 0xF8000000,
		0x1B80, 0x00000007,
		0x1B80, 0x090A0005,
		0x1B80, 0x090A0007,
		0x1B80, 0x0FFE0015,
		0x1B80, 0x0FFE0017,
		0x1B80, 0x00220025,
		0x1B80, 0x00220027,
		0x1B80, 0x00040035,
		0x1B80, 0x00040037,
		0x1B80, 0x05C00045,
		0x1B80, 0x05C00047,
		0x1B80, 0x00070055,
		0x1B80, 0x00070057,
		0x1B80, 0x64000065,
		0x1B80, 0x64000067,
		0x1B80, 0x00020075,
		0x1B80, 0x00020077,
		0x1B80, 0x00080085,
		0x1B80, 0x00080087,
		0x1B80, 0x80000095,
		0x1B80, 0x80000097,
		0x1B80, 0x090800A5,
		0x1B80, 0x090800A7,
		0x1B80, 0x0F0200B5,
		0x1B80, 0x0F0200B7,
		0x1B80, 0x002200C5,
		0x1B80, 0x002200C7,
		0x1B80, 0x000400D5,
		0x1B80, 0x000400D7,
		0x1B80, 0x05C000E5,
		0x1B80, 0x05C000E7,
		0x1B80, 0x000700F5,
		0x1B80, 0x000700F7,
		0x1B80, 0x64020105,
		0x1B80, 0x64020107,
		0x1B80, 0x00020115,
		0x1B80, 0x00020117,
		0x1B80, 0x00040125,
		0x1B80, 0x00040127,
		0x1B80, 0x4A000135,
		0x1B80, 0x4A000137,
		0x1B80, 0x4B040145,
		0x1B80, 0x4B040147,
		0x1B80, 0x85030155,
		0x1B80, 0x85030157,
		0x1B80, 0x40090165,
		0x1B80, 0x40090167,
		0x1B80, 0xE0280175,
		0x1B80, 0xE0280177,
		0x1B80, 0x4B050185,
		0x1B80, 0x4B050187,
		0x1B80, 0x86030195,
		0x1B80, 0x86030197,
		0x1B80, 0x400B01A5,
		0x1B80, 0x400B01A7,
		0x1B80, 0xE02801B5,
		0x1B80, 0xE02801B7,
		0x1B80, 0x4B0001C5,
		0x1B80, 0x4B0001C7,
		0x1B80, 0x000701D5,
		0x1B80, 0x000701D7,
		0x1B80, 0x4C0001E5,
		0x1B80, 0x4C0001E7,
		0x1B80, 0x000401F5,
		0x1B80, 0x000401F7,
		0x1B80, 0x4D040205,
		0x1B80, 0x4D040207,
		0x1B80, 0x2EF00215,
		0x1B80, 0x2EF00217,
		0x1B80, 0x00000225,
		0x1B80, 0x00000227,
		0x1B80, 0x20810235,
		0x1B80, 0x20810237,
		0x1B80, 0x23450245,
		0x1B80, 0x23450247,
		0x1B80, 0x4D000255,
		0x1B80, 0x4D000257,
		0x1B80, 0x00040265,
		0x1B80, 0x00040267,
		0x1B80, 0x30000275,
		0x1B80, 0x30000277,
		0x1B80, 0xE1D80285,
		0x1B80, 0xE1D80287,
		0x1B80, 0xF0110295,
		0x1B80, 0xF0110297,
		0x1B80, 0xF11102A5,
		0x1B80, 0xF11102A7,
		0x1B80, 0xF21102B5,
		0x1B80, 0xF21102B7,
		0x1B80, 0xF31102C5,
		0x1B80, 0xF31102C7,
		0x1B80, 0xF41102D5,
		0x1B80, 0xF41102D7,
		0x1B80, 0xF51102E5,
		0x1B80, 0xF51102E7,
		0x1B80, 0xF61102F5,
		0x1B80, 0xF61102F7,
		0x1B80, 0xF7110305,
		0x1B80, 0xF7110307,
		0x1B80, 0xF8110315,
		0x1B80, 0xF8110317,
		0x1B80, 0xF9110325,
		0x1B80, 0xF9110327,
		0x1B80, 0xFA110335,
		0x1B80, 0xFA110337,
		0x1B80, 0xFB110345,
		0x1B80, 0xFB110347,
		0x1B80, 0xFC110355,
		0x1B80, 0xFC110357,
		0x1B80, 0xFD110365,
		0x1B80, 0xFD110367,
		0x1B80, 0xFE110375,
		0x1B80, 0xFE110377,
		0x1B80, 0xFF110385,
		0x1B80, 0xFF110387,
		0x1B80, 0x00010395,
		0x1B80, 0x00010397,
		0x1B80, 0x305103A5,
		0x1B80, 0x305103A7,
		0x1B80, 0x306903B5,
		0x1B80, 0x306903B7,
		0x1B80, 0x30B403C5,
		0x1B80, 0x30B403C7,
		0x1B80, 0x30B703D5,
		0x1B80, 0x30B703D7,
		0x1B80, 0x306B03E5,
		0x1B80, 0x306B03E7,
		0x1B80, 0x307603F5,
		0x1B80, 0x307603F7,
		0x1B80, 0x30810405,
		0x1B80, 0x30810407,
		0x1B80, 0x30C10415,
		0x1B80, 0x30C10417,
		0x1B80, 0x30BB0425,
		0x1B80, 0x30BB0427,
		0x1B80, 0x30CF0435,
		0x1B80, 0x30CF0437,
		0x1B80, 0x30DA0445,
		0x1B80, 0x30DA0447,
		0x1B80, 0x30E50455,
		0x1B80, 0x30E50457,
		0x1B80, 0x304A0465,
		0x1B80, 0x304A0467,
		0x1B80, 0x31140475,
		0x1B80, 0x31140477,
		0x1B80, 0x31250485,
		0x1B80, 0x31250487,
		0x1B80, 0x313A0495,
		0x1B80, 0x313A0497,
		0x1B80, 0x4D0404A5,
		0x1B80, 0x4D0404A7,
		0x1B80, 0x2EF004B5,
		0x1B80, 0x2EF004B7,
		0x1B80, 0x000004C5,
		0x1B80, 0x000004C7,
		0x1B80, 0x208104D5,
		0x1B80, 0x208104D7,
		0x1B80, 0xA3B504E5,
		0x1B80, 0xA3B504E7,
		0x1B80, 0x4D0004F5,
		0x1B80, 0x4D0004F7,
		0x1B80, 0x30000505,
		0x1B80, 0x30000507,
		0x1B80, 0xE1650515,
		0x1B80, 0xE1650517,
		0x1B80, 0x4D040525,
		0x1B80, 0x4D040527,
		0x1B80, 0x20800535,
		0x1B80, 0x20800537,
		0x1B80, 0x00000545,
		0x1B80, 0x00000547,
		0x1B80, 0x4D000555,
		0x1B80, 0x4D000557,
		0x1B80, 0x55070565,
		0x1B80, 0x55070567,
		0x1B80, 0xE15D0575,
		0x1B80, 0xE15D0577,
		0x1B80, 0xE15D0585,
		0x1B80, 0xE15D0587,
		0x1B80, 0x4D040595,
		0x1B80, 0x4D040597,
		0x1B80, 0x208805A5,
		0x1B80, 0x208805A7,
		0x1B80, 0x020005B5,
		0x1B80, 0x020005B7,
		0x1B80, 0x4D0005C5,
		0x1B80, 0x4D0005C7,
		0x1B80, 0x550F05D5,
		0x1B80, 0x550F05D7,
		0x1B80, 0xE15D05E5,
		0x1B80, 0xE15D05E7,
		0x1B80, 0x4F0205F5,
		0x1B80, 0x4F0205F7,
		0x1B80, 0x4E000605,
		0x1B80, 0x4E000607,
		0x1B80, 0x53020615,
		0x1B80, 0x53020617,
		0x1B80, 0x52010625,
		0x1B80, 0x52010627,
		0x1B80, 0xE1610635,
		0x1B80, 0xE1610637,
		0x1B80, 0x4D080645,
		0x1B80, 0x4D080647,
		0x1B80, 0x57100655,
		0x1B80, 0x57100657,
		0x1B80, 0x57000665,
		0x1B80, 0x57000667,
		0x1B80, 0x4D000675,
		0x1B80, 0x4D000677,
		0x1B80, 0x00010685,
		0x1B80, 0x00010687,
		0x1B80, 0xE1650695,
		0x1B80, 0xE1650697,
		0x1B80, 0x000106A5,
		0x1B80, 0x000106A7,
		0x1B80, 0x308B06B5,
		0x1B80, 0x308B06B7,
		0x1B80, 0x002306C5,
		0x1B80, 0x002306C7,
		0x1B80, 0xE1CB06D5,
		0x1B80, 0xE1CB06D7,
		0x1B80, 0x000206E5,
		0x1B80, 0x000206E7,
		0x1B80, 0x54E906F5,
		0x1B80, 0x54E906F7,
		0x1B80, 0x0BA60705,
		0x1B80, 0x0BA60707,
		0x1B80, 0x00230715,
		0x1B80, 0x00230717,
		0x1B80, 0xE1CB0725,
		0x1B80, 0xE1CB0727,
		0x1B80, 0x00020735,
		0x1B80, 0x00020737,
		0x1B80, 0x4D300745,
		0x1B80, 0x4D300747,
		0x1B80, 0x30A40755,
		0x1B80, 0x30A40757,
		0x1B80, 0x30870765,
		0x1B80, 0x30870767,
		0x1B80, 0x00220775,
		0x1B80, 0x00220777,
		0x1B80, 0xE1CB0785,
		0x1B80, 0xE1CB0787,
		0x1B80, 0x00020795,
		0x1B80, 0x00020797,
		0x1B80, 0x54E807A5,
		0x1B80, 0x54E807A7,
		0x1B80, 0x0BA607B5,
		0x1B80, 0x0BA607B7,
		0x1B80, 0x002207C5,
		0x1B80, 0x002207C7,
		0x1B80, 0xE1CB07D5,
		0x1B80, 0xE1CB07D7,
		0x1B80, 0x000207E5,
		0x1B80, 0x000207E7,
		0x1B80, 0x4D3007F5,
		0x1B80, 0x4D3007F7,
		0x1B80, 0x30A40805,
		0x1B80, 0x30A40807,
		0x1B80, 0x63F10815,
		0x1B80, 0x63F10817,
		0x1B80, 0xE1650825,
		0x1B80, 0xE1650827,
		0x1B80, 0xE1CB0835,
		0x1B80, 0xE1CB0837,
		0x1B80, 0x63F40845,
		0x1B80, 0x63F40847,
		0x1B80, 0xE1650855,
		0x1B80, 0xE1650857,
		0x1B80, 0xE1CB0865,
		0x1B80, 0xE1CB0867,
		0x1B80, 0x0BA80875,
		0x1B80, 0x0BA80877,
		0x1B80, 0x63F80885,
		0x1B80, 0x63F80887,
		0x1B80, 0xE1650895,
		0x1B80, 0xE1650897,
		0x1B80, 0xE1CB08A5,
		0x1B80, 0xE1CB08A7,
		0x1B80, 0x0BA908B5,
		0x1B80, 0x0BA908B7,
		0x1B80, 0x63FC08C5,
		0x1B80, 0x63FC08C7,
		0x1B80, 0xE16508D5,
		0x1B80, 0xE16508D7,
		0x1B80, 0xE1CB08E5,
		0x1B80, 0xE1CB08E7,
		0x1B80, 0x63FF08F5,
		0x1B80, 0x63FF08F7,
		0x1B80, 0xE1650905,
		0x1B80, 0xE1650907,
		0x1B80, 0xE1CB0915,
		0x1B80, 0xE1CB0917,
		0x1B80, 0x63000925,
		0x1B80, 0x63000927,
		0x1B80, 0xE1650935,
		0x1B80, 0xE1650937,
		0x1B80, 0xE1CB0945,
		0x1B80, 0xE1CB0947,
		0x1B80, 0x63030955,
		0x1B80, 0x63030957,
		0x1B80, 0xE1650965,
		0x1B80, 0xE1650967,
		0x1B80, 0xE1CB0975,
		0x1B80, 0xE1CB0977,
		0x1B80, 0xF4D40985,
		0x1B80, 0xF4D40987,
		0x1B80, 0x63070995,
		0x1B80, 0x63070997,
		0x1B80, 0xE16509A5,
		0x1B80, 0xE16509A7,
		0x1B80, 0xE1CB09B5,
		0x1B80, 0xE1CB09B7,
		0x1B80, 0xF5DB09C5,
		0x1B80, 0xF5DB09C7,
		0x1B80, 0x630B09D5,
		0x1B80, 0x630B09D7,
		0x1B80, 0xE16509E5,
		0x1B80, 0xE16509E7,
		0x1B80, 0xE1CB09F5,
		0x1B80, 0xE1CB09F7,
		0x1B80, 0x630E0A05,
		0x1B80, 0x630E0A07,
		0x1B80, 0xE1650A15,
		0x1B80, 0xE1650A17,
		0x1B80, 0xE1CB0A25,
		0x1B80, 0xE1CB0A27,
		0x1B80, 0x4D300A35,
		0x1B80, 0x4D300A37,
		0x1B80, 0x55010A45,
		0x1B80, 0x55010A47,
		0x1B80, 0x57040A55,
		0x1B80, 0x57040A57,
		0x1B80, 0x57000A65,
		0x1B80, 0x57000A67,
		0x1B80, 0x96000A75,
		0x1B80, 0x96000A77,
		0x1B80, 0x57080A85,
		0x1B80, 0x57080A87,
		0x1B80, 0x57000A95,
		0x1B80, 0x57000A97,
		0x1B80, 0x95000AA5,
		0x1B80, 0x95000AA7,
		0x1B80, 0x4D000AB5,
		0x1B80, 0x4D000AB7,
		0x1B80, 0x6C070AC5,
		0x1B80, 0x6C070AC7,
		0x1B80, 0x7B200AD5,
		0x1B80, 0x7B200AD7,
		0x1B80, 0x7A000AE5,
		0x1B80, 0x7A000AE7,
		0x1B80, 0x79000AF5,
		0x1B80, 0x79000AF7,
		0x1B80, 0x7F200B05,
		0x1B80, 0x7F200B07,
		0x1B80, 0x7E000B15,
		0x1B80, 0x7E000B17,
		0x1B80, 0x7D000B25,
		0x1B80, 0x7D000B27,
		0x1B80, 0x00010B35,
		0x1B80, 0x00010B37,
		0x1B80, 0x62850B45,
		0x1B80, 0x62850B47,
		0x1B80, 0xE1650B55,
		0x1B80, 0xE1650B57,
		0x1B80, 0x00010B65,
		0x1B80, 0x00010B67,
		0x1B80, 0x5C320B75,
		0x1B80, 0x5C320B77,
		0x1B80, 0xE1C70B85,
		0x1B80, 0xE1C70B87,
		0x1B80, 0xE1930B95,
		0x1B80, 0xE1930B97,
		0x1B80, 0x00010BA5,
		0x1B80, 0x00010BA7,
		0x1B80, 0x5C320BB5,
		0x1B80, 0x5C320BB7,
		0x1B80, 0x63F40BC5,
		0x1B80, 0x63F40BC7,
		0x1B80, 0x62850BD5,
		0x1B80, 0x62850BD7,
		0x1B80, 0x0BB00BE5,
		0x1B80, 0x0BB00BE7,
		0x1B80, 0xE1650BF5,
		0x1B80, 0xE1650BF7,
		0x1B80, 0xE1CB0C05,
		0x1B80, 0xE1CB0C07,
		0x1B80, 0x5C320C15,
		0x1B80, 0x5C320C17,
		0x1B80, 0x63FC0C25,
		0x1B80, 0x63FC0C27,
		0x1B80, 0x62850C35,
		0x1B80, 0x62850C37,
		0x1B80, 0x0BB10C45,
		0x1B80, 0x0BB10C47,
		0x1B80, 0xE1650C55,
		0x1B80, 0xE1650C57,
		0x1B80, 0xE1CB0C65,
		0x1B80, 0xE1CB0C67,
		0x1B80, 0x63030C75,
		0x1B80, 0x63030C77,
		0x1B80, 0xE1650C85,
		0x1B80, 0xE1650C87,
		0x1B80, 0xE1CB0C95,
		0x1B80, 0xE1CB0C97,
		0x1B80, 0xF7040CA5,
		0x1B80, 0xF7040CA7,
		0x1B80, 0x630B0CB5,
		0x1B80, 0x630B0CB7,
		0x1B80, 0xE1650CC5,
		0x1B80, 0xE1650CC7,
		0x1B80, 0xE1CB0CD5,
		0x1B80, 0xE1CB0CD7,
		0x1B80, 0x00010CE5,
		0x1B80, 0x00010CE7,
		0x1B80, 0x30F30CF5,
		0x1B80, 0x30F30CF7,
		0x1B80, 0x00230D05,
		0x1B80, 0x00230D07,
		0x1B80, 0xE1D00D15,
		0x1B80, 0xE1D00D17,
		0x1B80, 0x00020D25,
		0x1B80, 0x00020D27,
		0x1B80, 0x54E90D35,
		0x1B80, 0x54E90D37,
		0x1B80, 0x0BA60D45,
		0x1B80, 0x0BA60D47,
		0x1B80, 0x00230D55,
		0x1B80, 0x00230D57,
		0x1B80, 0xE1D00D65,
		0x1B80, 0xE1D00D67,
		0x1B80, 0x00020D75,
		0x1B80, 0x00020D77,
		0x1B80, 0x4D100D85,
		0x1B80, 0x4D100D87,
		0x1B80, 0x30A40D95,
		0x1B80, 0x30A40D97,
		0x1B80, 0x30ED0DA5,
		0x1B80, 0x30ED0DA7,
		0x1B80, 0x00220DB5,
		0x1B80, 0x00220DB7,
		0x1B80, 0xE1D00DC5,
		0x1B80, 0xE1D00DC7,
		0x1B80, 0x00020DD5,
		0x1B80, 0x00020DD7,
		0x1B80, 0x54E80DE5,
		0x1B80, 0x54E80DE7,
		0x1B80, 0x0BA60DF5,
		0x1B80, 0x0BA60DF7,
		0x1B80, 0x00220E05,
		0x1B80, 0x00220E07,
		0x1B80, 0xE1D00E15,
		0x1B80, 0xE1D00E17,
		0x1B80, 0x00020E25,
		0x1B80, 0x00020E27,
		0x1B80, 0x4D100E35,
		0x1B80, 0x4D100E37,
		0x1B80, 0x30A40E45,
		0x1B80, 0x30A40E47,
		0x1B80, 0x5C320E55,
		0x1B80, 0x5C320E57,
		0x1B80, 0x54F00E65,
		0x1B80, 0x54F00E67,
		0x1B80, 0x67F10E75,
		0x1B80, 0x67F10E77,
		0x1B80, 0xE1930E85,
		0x1B80, 0xE1930E87,
		0x1B80, 0xE1D00E95,
		0x1B80, 0xE1D00E97,
		0x1B80, 0x67F40EA5,
		0x1B80, 0x67F40EA7,
		0x1B80, 0xE1930EB5,
		0x1B80, 0xE1930EB7,
		0x1B80, 0xE1D00EC5,
		0x1B80, 0xE1D00EC7,
		0x1B80, 0x5C320ED5,
		0x1B80, 0x5C320ED7,
		0x1B80, 0x54F10EE5,
		0x1B80, 0x54F10EE7,
		0x1B80, 0x0BA80EF5,
		0x1B80, 0x0BA80EF7,
		0x1B80, 0x67F80F05,
		0x1B80, 0x67F80F07,
		0x1B80, 0xE1930F15,
		0x1B80, 0xE1930F17,
		0x1B80, 0xE1D00F25,
		0x1B80, 0xE1D00F27,
		0x1B80, 0x5C320F35,
		0x1B80, 0x5C320F37,
		0x1B80, 0x54F10F45,
		0x1B80, 0x54F10F47,
		0x1B80, 0x0BA90F55,
		0x1B80, 0x0BA90F57,
		0x1B80, 0x67FC0F65,
		0x1B80, 0x67FC0F67,
		0x1B80, 0xE1930F75,
		0x1B80, 0xE1930F77,
		0x1B80, 0xE1D00F85,
		0x1B80, 0xE1D00F87,
		0x1B80, 0x67FF0F95,
		0x1B80, 0x67FF0F97,
		0x1B80, 0xE1930FA5,
		0x1B80, 0xE1930FA7,
		0x1B80, 0xE1D00FB5,
		0x1B80, 0xE1D00FB7,
		0x1B80, 0x5C320FC5,
		0x1B80, 0x5C320FC7,
		0x1B80, 0x54F20FD5,
		0x1B80, 0x54F20FD7,
		0x1B80, 0x67000FE5,
		0x1B80, 0x67000FE7,
		0x1B80, 0xE1930FF5,
		0x1B80, 0xE1930FF7,
		0x1B80, 0xE1D01005,
		0x1B80, 0xE1D01007,
		0x1B80, 0x67031015,
		0x1B80, 0x67031017,
		0x1B80, 0xE1931025,
		0x1B80, 0xE1931027,
		0x1B80, 0xE1D01035,
		0x1B80, 0xE1D01037,
		0x1B80, 0xF9CC1045,
		0x1B80, 0xF9CC1047,
		0x1B80, 0x67071055,
		0x1B80, 0x67071057,
		0x1B80, 0xE1931065,
		0x1B80, 0xE1931067,
		0x1B80, 0xE1D01075,
		0x1B80, 0xE1D01077,
		0x1B80, 0xFAD31085,
		0x1B80, 0xFAD31087,
		0x1B80, 0x5C321095,
		0x1B80, 0x5C321097,
		0x1B80, 0x54F310A5,
		0x1B80, 0x54F310A7,
		0x1B80, 0x670B10B5,
		0x1B80, 0x670B10B7,
		0x1B80, 0xE19310C5,
		0x1B80, 0xE19310C7,
		0x1B80, 0xE1D010D5,
		0x1B80, 0xE1D010D7,
		0x1B80, 0x670E10E5,
		0x1B80, 0x670E10E7,
		0x1B80, 0xE19310F5,
		0x1B80, 0xE19310F7,
		0x1B80, 0xE1D01105,
		0x1B80, 0xE1D01107,
		0x1B80, 0x4D101115,
		0x1B80, 0x4D101117,
		0x1B80, 0x30A41125,
		0x1B80, 0x30A41127,
		0x1B80, 0x00011135,
		0x1B80, 0x00011137,
		0x1B80, 0x6C001145,
		0x1B80, 0x6C001147,
		0x1B80, 0x00061155,
		0x1B80, 0x00061157,
		0x1B80, 0x53001165,
		0x1B80, 0x53001167,
		0x1B80, 0x57F71175,
		0x1B80, 0x57F71177,
		0x1B80, 0x58211185,
		0x1B80, 0x58211187,
		0x1B80, 0x592E1195,
		0x1B80, 0x592E1197,
		0x1B80, 0x5A3811A5,
		0x1B80, 0x5A3811A7,
		0x1B80, 0x5B4111B5,
		0x1B80, 0x5B4111B7,
		0x1B80, 0x000711C5,
		0x1B80, 0x000711C7,
		0x1B80, 0x5C0011D5,
		0x1B80, 0x5C0011D7,
		0x1B80, 0x4B0011E5,
		0x1B80, 0x4B0011E7,
		0x1B80, 0x4E8F11F5,
		0x1B80, 0x4E8F11F7,
		0x1B80, 0x4F151205,
		0x1B80, 0x4F151207,
		0x1B80, 0x00041215,
		0x1B80, 0x00041217,
		0x1B80, 0xE1B51225,
		0x1B80, 0xE1B51227,
		0x1B80, 0xAB001235,
		0x1B80, 0xAB001237,
		0x1B80, 0x00011245,
		0x1B80, 0x00011247,
		0x1B80, 0x6C001255,
		0x1B80, 0x6C001257,
		0x1B80, 0x00061265,
		0x1B80, 0x00061267,
		0x1B80, 0x53001275,
		0x1B80, 0x53001277,
		0x1B80, 0x57F71285,
		0x1B80, 0x57F71287,
		0x1B80, 0x58211295,
		0x1B80, 0x58211297,
		0x1B80, 0x592E12A5,
		0x1B80, 0x592E12A7,
		0x1B80, 0x5A3812B5,
		0x1B80, 0x5A3812B7,
		0x1B80, 0x5B4112C5,
		0x1B80, 0x5B4112C7,
		0x1B80, 0x000712D5,
		0x1B80, 0x000712D7,
		0x1B80, 0x5C0012E5,
		0x1B80, 0x5C0012E7,
		0x1B80, 0x4B4012F5,
		0x1B80, 0x4B4012F7,
		0x1B80, 0x4E971305,
		0x1B80, 0x4E971307,
		0x1B80, 0x4F111315,
		0x1B80, 0x4F111317,
		0x1B80, 0x00041325,
		0x1B80, 0x00041327,
		0x1B80, 0xE1B51335,
		0x1B80, 0xE1B51337,
		0x1B80, 0xAB001345,
		0x1B80, 0xAB001347,
		0x1B80, 0x8B001355,
		0x1B80, 0x8B001357,
		0x1B80, 0xAB001365,
		0x1B80, 0xAB001367,
		0x1B80, 0x8A191375,
		0x1B80, 0x8A191377,
		0x1B80, 0x301D1385,
		0x1B80, 0x301D1387,
		0x1B80, 0x00011395,
		0x1B80, 0x00011397,
		0x1B80, 0x6C0113A5,
		0x1B80, 0x6C0113A7,
		0x1B80, 0x000613B5,
		0x1B80, 0x000613B7,
		0x1B80, 0x530113C5,
		0x1B80, 0x530113C7,
		0x1B80, 0x57F713D5,
		0x1B80, 0x57F713D7,
		0x1B80, 0x582113E5,
		0x1B80, 0x582113E7,
		0x1B80, 0x592E13F5,
		0x1B80, 0x592E13F7,
		0x1B80, 0x5A381405,
		0x1B80, 0x5A381407,
		0x1B80, 0x5B411415,
		0x1B80, 0x5B411417,
		0x1B80, 0x00071425,
		0x1B80, 0x00071427,
		0x1B80, 0x5C001435,
		0x1B80, 0x5C001437,
		0x1B80, 0x4B001445,
		0x1B80, 0x4B001447,
		0x1B80, 0x4E871455,
		0x1B80, 0x4E871457,
		0x1B80, 0x4F111465,
		0x1B80, 0x4F111467,
		0x1B80, 0x00041475,
		0x1B80, 0x00041477,
		0x1B80, 0xE1B51485,
		0x1B80, 0xE1B51487,
		0x1B80, 0xAB001495,
		0x1B80, 0xAB001497,
		0x1B80, 0x000614A5,
		0x1B80, 0x000614A7,
		0x1B80, 0x577714B5,
		0x1B80, 0x577714B7,
		0x1B80, 0x000714C5,
		0x1B80, 0x000714C7,
		0x1B80, 0x4E8614D5,
		0x1B80, 0x4E8614D7,
		0x1B80, 0x000414E5,
		0x1B80, 0x000414E7,
		0x1B80, 0x000114F5,
		0x1B80, 0x000114F7,
		0x1B80, 0x00011505,
		0x1B80, 0x00011507,
		0x1B80, 0x7B241515,
		0x1B80, 0x7B241517,
		0x1B80, 0x7A401525,
		0x1B80, 0x7A401527,
		0x1B80, 0x79001535,
		0x1B80, 0x79001537,
		0x1B80, 0x55031545,
		0x1B80, 0x55031547,
		0x1B80, 0x315D1555,
		0x1B80, 0x315D1557,
		0x1B80, 0x7B1C1565,
		0x1B80, 0x7B1C1567,
		0x1B80, 0x7A401575,
		0x1B80, 0x7A401577,
		0x1B80, 0x550B1585,
		0x1B80, 0x550B1587,
		0x1B80, 0x315D1595,
		0x1B80, 0x315D1597,
		0x1B80, 0x7B2015A5,
		0x1B80, 0x7B2015A7,
		0x1B80, 0x7A0015B5,
		0x1B80, 0x7A0015B7,
		0x1B80, 0x551315C5,
		0x1B80, 0x551315C7,
		0x1B80, 0x740115D5,
		0x1B80, 0x740115D7,
		0x1B80, 0x740015E5,
		0x1B80, 0x740015E7,
		0x1B80, 0x8E0015F5,
		0x1B80, 0x8E0015F7,
		0x1B80, 0x00011605,
		0x1B80, 0x00011607,
		0x1B80, 0x57021615,
		0x1B80, 0x57021617,
		0x1B80, 0x57001625,
		0x1B80, 0x57001627,
		0x1B80, 0x97001635,
		0x1B80, 0x97001637,
		0x1B80, 0x00011645,
		0x1B80, 0x00011647,
		0x1B80, 0x4F781655,
		0x1B80, 0x4F781657,
		0x1B80, 0x53881665,
		0x1B80, 0x53881667,
		0x1B80, 0xE1731675,
		0x1B80, 0xE1731677,
		0x1B80, 0x54801685,
		0x1B80, 0x54801687,
		0x1B80, 0x54001695,
		0x1B80, 0x54001697,
		0x1B80, 0xE17316A5,
		0x1B80, 0xE17316A7,
		0x1B80, 0x548116B5,
		0x1B80, 0x548116B7,
		0x1B80, 0x540016C5,
		0x1B80, 0x540016C7,
		0x1B80, 0xE17316D5,
		0x1B80, 0xE17316D7,
		0x1B80, 0x548216E5,
		0x1B80, 0x548216E7,
		0x1B80, 0x540016F5,
		0x1B80, 0x540016F7,
		0x1B80, 0xE17E1705,
		0x1B80, 0xE17E1707,
		0x1B80, 0xBF1D1715,
		0x1B80, 0xBF1D1717,
		0x1B80, 0x301D1725,
		0x1B80, 0x301D1727,
		0x1B80, 0xE1511735,
		0x1B80, 0xE1511737,
		0x1B80, 0xE1561745,
		0x1B80, 0xE1561747,
		0x1B80, 0xE15A1755,
		0x1B80, 0xE15A1757,
		0x1B80, 0xE1611765,
		0x1B80, 0xE1611767,
		0x1B80, 0xE1C71775,
		0x1B80, 0xE1C71777,
		0x1B80, 0x55131785,
		0x1B80, 0x55131787,
		0x1B80, 0xE15D1795,
		0x1B80, 0xE15D1797,
		0x1B80, 0x551517A5,
		0x1B80, 0x551517A7,
		0x1B80, 0xE16117B5,
		0x1B80, 0xE16117B7,
		0x1B80, 0xE1C717C5,
		0x1B80, 0xE1C717C7,
		0x1B80, 0x000117D5,
		0x1B80, 0x000117D7,
		0x1B80, 0x54BF17E5,
		0x1B80, 0x54BF17E7,
		0x1B80, 0x54C017F5,
		0x1B80, 0x54C017F7,
		0x1B80, 0x54A31805,
		0x1B80, 0x54A31807,
		0x1B80, 0x54C11815,
		0x1B80, 0x54C11817,
		0x1B80, 0x54A41825,
		0x1B80, 0x54A41827,
		0x1B80, 0x4C181835,
		0x1B80, 0x4C181837,
		0x1B80, 0xBF071845,
		0x1B80, 0xBF071847,
		0x1B80, 0x54C21855,
		0x1B80, 0x54C21857,
		0x1B80, 0x54A41865,
		0x1B80, 0x54A41867,
		0x1B80, 0xBF041875,
		0x1B80, 0xBF041877,
		0x1B80, 0x54C11885,
		0x1B80, 0x54C11887,
		0x1B80, 0x54A31895,
		0x1B80, 0x54A31897,
		0x1B80, 0xBF0118A5,
		0x1B80, 0xBF0118A7,
		0x1B80, 0xE1D518B5,
		0x1B80, 0xE1D518B7,
		0x1B80, 0x54DF18C5,
		0x1B80, 0x54DF18C7,
		0x1B80, 0x000118D5,
		0x1B80, 0x000118D7,
		0x1B80, 0x54BF18E5,
		0x1B80, 0x54BF18E7,
		0x1B80, 0x54E518F5,
		0x1B80, 0x54E518F7,
		0x1B80, 0x050A1905,
		0x1B80, 0x050A1907,
		0x1B80, 0x54DF1915,
		0x1B80, 0x54DF1917,
		0x1B80, 0x00011925,
		0x1B80, 0x00011927,
		0x1B80, 0x7F201935,
		0x1B80, 0x7F201937,
		0x1B80, 0x7E001945,
		0x1B80, 0x7E001947,
		0x1B80, 0x7D001955,
		0x1B80, 0x7D001957,
		0x1B80, 0x55011965,
		0x1B80, 0x55011967,
		0x1B80, 0x5C311975,
		0x1B80, 0x5C311977,
		0x1B80, 0xE15D1985,
		0x1B80, 0xE15D1987,
		0x1B80, 0xE1611995,
		0x1B80, 0xE1611997,
		0x1B80, 0x548019A5,
		0x1B80, 0x548019A7,
		0x1B80, 0x540019B5,
		0x1B80, 0x540019B7,
		0x1B80, 0xE15D19C5,
		0x1B80, 0xE15D19C7,
		0x1B80, 0xE16119D5,
		0x1B80, 0xE16119D7,
		0x1B80, 0x548119E5,
		0x1B80, 0x548119E7,
		0x1B80, 0x540019F5,
		0x1B80, 0x540019F7,
		0x1B80, 0xE15D1A05,
		0x1B80, 0xE15D1A07,
		0x1B80, 0xE1611A15,
		0x1B80, 0xE1611A17,
		0x1B80, 0x54821A25,
		0x1B80, 0x54821A27,
		0x1B80, 0x54001A35,
		0x1B80, 0x54001A37,
		0x1B80, 0xE17E1A45,
		0x1B80, 0xE17E1A47,
		0x1B80, 0xBFE91A55,
		0x1B80, 0xBFE91A57,
		0x1B80, 0x301D1A65,
		0x1B80, 0x301D1A67,
		0x1B80, 0x00231A75,
		0x1B80, 0x00231A77,
		0x1B80, 0x7B201A85,
		0x1B80, 0x7B201A87,
		0x1B80, 0x7A001A95,
		0x1B80, 0x7A001A97,
		0x1B80, 0x79001AA5,
		0x1B80, 0x79001AA7,
		0x1B80, 0xE1CB1AB5,
		0x1B80, 0xE1CB1AB7,
		0x1B80, 0x00021AC5,
		0x1B80, 0x00021AC7,
		0x1B80, 0x00011AD5,
		0x1B80, 0x00011AD7,
		0x1B80, 0x00221AE5,
		0x1B80, 0x00221AE7,
		0x1B80, 0x7B201AF5,
		0x1B80, 0x7B201AF7,
		0x1B80, 0x7A001B05,
		0x1B80, 0x7A001B07,
		0x1B80, 0x79001B15,
		0x1B80, 0x79001B17,
		0x1B80, 0xE1CB1B25,
		0x1B80, 0xE1CB1B27,
		0x1B80, 0x00021B35,
		0x1B80, 0x00021B37,
		0x1B80, 0x00011B45,
		0x1B80, 0x00011B47,
		0x1B80, 0x74021B55,
		0x1B80, 0x74021B57,
		0x1B80, 0x003F1B65,
		0x1B80, 0x003F1B67,
		0x1B80, 0x74001B75,
		0x1B80, 0x74001B77,
		0x1B80, 0x00021B85,
		0x1B80, 0x00021B87,
		0x1B80, 0x00011B95,
		0x1B80, 0x00011B97,
		0x1B80, 0x4D041BA5,
		0x1B80, 0x4D041BA7,
		0x1B80, 0x2EF81BB5,
		0x1B80, 0x2EF81BB7,
		0x1B80, 0x00001BC5,
		0x1B80, 0x00001BC7,
		0x1B80, 0x23301BD5,
		0x1B80, 0x23301BD7,
		0x1B80, 0x00241BE5,
		0x1B80, 0x00241BE7,
		0x1B80, 0x23E01BF5,
		0x1B80, 0x23E01BF7,
		0x1B80, 0x003F1C05,
		0x1B80, 0x003F1C07,
		0x1B80, 0x23FC1C15,
		0x1B80, 0x23FC1C17,
		0x1B80, 0xBFCE1C25,
		0x1B80, 0xBFCE1C27,
		0x1B80, 0x2EF01C35,
		0x1B80, 0x2EF01C37,
		0x1B80, 0x00001C45,
		0x1B80, 0x00001C47,
		0x1B80, 0x4D001C55,
		0x1B80, 0x4D001C57,
		0x1B80, 0x00011C65,
		0x1B80, 0x00011C67,
		0x1B80, 0x549F1C75,
		0x1B80, 0x549F1C77,
		0x1B80, 0x54FF1C85,
		0x1B80, 0x54FF1C87,
		0x1B80, 0x54001C95,
		0x1B80, 0x54001C97,
		0x1B80, 0x00011CA5,
		0x1B80, 0x00011CA7,
		0x1B80, 0x5C311CB5,
		0x1B80, 0x5C311CB7,
		0x1B80, 0x07141CC5,
		0x1B80, 0x07141CC7,
		0x1B80, 0x54001CD5,
		0x1B80, 0x54001CD7,
		0x1B80, 0x5C321CE5,
		0x1B80, 0x5C321CE7,
		0x1B80, 0x00011CF5,
		0x1B80, 0x00011CF7,
		0x1B80, 0x5C321D05,
		0x1B80, 0x5C321D07,
		0x1B80, 0x07141D15,
		0x1B80, 0x07141D17,
		0x1B80, 0x54001D25,
		0x1B80, 0x54001D27,
		0x1B80, 0x5C311D35,
		0x1B80, 0x5C311D37,
		0x1B80, 0x00011D45,
		0x1B80, 0x00011D47,
		0x1B80, 0x4C981D55,
		0x1B80, 0x4C981D57,
		0x1B80, 0x4C181D65,
		0x1B80, 0x4C181D67,
		0x1B80, 0x00011D75,
		0x1B80, 0x00011D77,
		0x1B80, 0x5C321D85,
		0x1B80, 0x5C321D87,
		0x1B80, 0x62841D95,
		0x1B80, 0x62841D97,
		0x1B80, 0x66861DA5,
		0x1B80, 0x66861DA7,
		0x1B80, 0x6C031DB5,
		0x1B80, 0x6C031DB7,
		0x1B80, 0x7B201DC5,
		0x1B80, 0x7B201DC7,
		0x1B80, 0x7A001DD5,
		0x1B80, 0x7A001DD7,
		0x1B80, 0x79001DE5,
		0x1B80, 0x79001DE7,
		0x1B80, 0x7F201DF5,
		0x1B80, 0x7F201DF7,
		0x1B80, 0x7E001E05,
		0x1B80, 0x7E001E07,
		0x1B80, 0x7D001E15,
		0x1B80, 0x7D001E17,
		0x1B80, 0x09011E25,
		0x1B80, 0x09011E27,
		0x1B80, 0x0C011E35,
		0x1B80, 0x0C011E37,
		0x1B80, 0x0BA61E45,
		0x1B80, 0x0BA61E47,
		0x1B80, 0x00011E55,
		0x1B80, 0x00011E57,
		0x1B80, 0x00000006,
		0x1B80, 0x00000002,

};

void
odm_read_and_config_mp_8822b_phy_reg(
	struct	PHY_DM_STRUCT *p_dm_odm
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8822b_phy_reg)/sizeof(u32);
	u32	*array = array_mp_8822b_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8822b_phy_reg\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8822b(p_dm_odm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8822b_phy_reg(void)
{
		return 85;
}

/******************************************************************************
*                           phy_reg_pg.TXT
******************************************************************************/

u32 array_mp_8822b_phy_reg_pg[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36384042,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x34363840,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x38402224,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x30323436,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x22242628,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x32343638,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x36384042,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x26283032,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x34363840,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x26283032,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x38402224,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x30323436,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x22242628,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34363840,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x32343638,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x36382022,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x28303234,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x20222426,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x34363840,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x26283032,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x24262830,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x32343638,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x32343638,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x24262830,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x36382022,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x28303234,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x20222426
};

void
odm_read_and_config_mp_8822b_phy_reg_pg(
	struct PHY_DM_STRUCT	*p_dm_odm
)
{
	u32	i = 0;
	u32	array_len = sizeof(array_mp_8822b_phy_reg_pg)/sizeof(u32);
	u32	*array = array_mp_8822b_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	struct _ADAPTER	*adapter = p_dm_odm->adapter;
	HAL_DATA_TYPE	*p_hal_data = GET_HAL_DATA(adapter);

	PlatformZeroMemory(p_hal_data->BufOfLinesPwrByRate, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	p_hal_data->nLinesReadPwrByRate = array_len/6;
#endif

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8822b_phy_reg_pg\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i+1];
		u32	v3 = array[i+2];
		u32	v4 = array[i+3];
		u32	v5 = array[i+4];
		u32	v6 = array[i+5];

		odm_config_bb_phy_reg_pg_8822b(p_dm_odm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)p_hal_data->BufOfLinesPwrByRate[i/6], 100, "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		(v1 == 0?"2.4G":"  5G"), (v2 == 0?"A":"B"), (v3 == 0?"1Tx":"2Tx"), v4, v5, v6);
#endif
	}
}



#endif /* end of HWIMG_SUPPORT*/

