/******************************************************************************
 *
 * Copyright(c) 2016 - 2017 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef _HAL_ORIGINALH2CFORMAT_H2C_C2H_AP_H_
#define _HAL_ORIGINALH2CFORMAT_H2C_C2H_AP_H_
#define CMD_ID_ORIGINAL_H2C  0X00
#define CMD_ID_H2C2H_LB  0X0
#define CMD_ID_D0_SCAN_OFFLOAD_CTRL  0X06
#define CMD_ID_RSVD_PAGE  0X0
#define CMD_ID_MEDIA_STATUS_RPT  0X01
#define CMD_ID_KEEP_ALIVE  0X03
#define CMD_ID_DISCONNECT_DECISION  0X04
#define CMD_ID_AP_OFFLOAD  0X08
#define CMD_ID_BCN_RSVDPAGE  0X09
#define CMD_ID_PROBE_RSP_RSVDPAGE  0X0A
#define CMD_ID_SET_PWR_MODE  0X00
#define CMD_ID_PS_TUNING_PARA  0X01
#define CMD_ID_PS_TUNING_PARA_II  0X02
#define CMD_ID_PS_LPS_PARA  0X03
#define CMD_ID_P2P_PS_OFFLOAD  0X04
#define CMD_ID_PS_SCAN_EN  0X05
#define CMD_ID_SAP_PS  0X06
#define CMD_ID_INACTIVE_PS  0X07
#define CMD_ID_MACID_CFG  0X00
#define CMD_ID_TXBF  0X01
#define CMD_ID_RSSI_SETTING  0X02
#define CMD_ID_AP_REQ_TXRPT  0X03
#define CMD_ID_INIT_RATE_COLLECTION  0X04
#define CMD_ID_IQK_OFFLOAD  0X05
#define CMD_ID_MACID_CFG_3SS  0X06
#define CMD_ID_RA_PARA_ADJUST  0X07
#define CMD_ID_WWLAN  0X00
#define CMD_ID_REMOTE_WAKE_CTRL  0X01
#define CMD_ID_AOAC_GLOBAL_INFO  0X02
#define CMD_ID_AOAC_RSVD_PAGE  0X03
#define CMD_ID_AOAC_RSVD_PAGE2  0X04
#define CMD_ID_D0_SCAN_OFFLOAD_INFO  0X05
#define CMD_ID_CHANNEL_SWITCH_OFFLOAD  0X07
#define CMD_ID_AOAC_RSVD_PAGE3  0X08
#define CLASS_ORIGINAL_H2C 0X00
#define CLASS_H2C2H_LB 0X07
#define CLASS_D0_SCAN_OFFLOAD_CTRL 0X04
#define CLASS_RSVD_PAGE 0X0
#define CLASS_MEDIA_STATUS_RPT 0X0
#define CLASS_KEEP_ALIVE 0X0
#define CLASS_DISCONNECT_DECISION 0X0
#define CLASS_AP_OFFLOAD 0X0
#define CLASS_BCN_RSVDPAGE 0X0
#define CLASS_PROBE_RSP_RSVDPAGE 0X0
#define CLASS_SET_PWR_MODE 0X01
#define CLASS_PS_TUNING_PARA 0X01
#define CLASS_PS_TUNING_PARA_II 0X01
#define CLASS_PS_LPS_PARA 0X01
#define CLASS_P2P_PS_OFFLOAD 0X01
#define CLASS_PS_SCAN_EN 0X1
#define CLASS_SAP_PS 0X1
#define CLASS_INACTIVE_PS 0X1
#define CLASS_MACID_CFG 0X2
#define CLASS_TXBF 0X2
#define CLASS_RSSI_SETTING 0X2
#define CLASS_AP_REQ_TXRPT 0X2
#define CLASS_INIT_RATE_COLLECTION 0X2
#define CLASS_IQK_OFFLOAD 0X2
#define CLASS_MACID_CFG_3SS 0X2
#define CLASS_RA_PARA_ADJUST 0X02
#define CLASS_WWLAN 0X4
#define CLASS_REMOTE_WAKE_CTRL 0X4
#define CLASS_AOAC_GLOBAL_INFO 0X04
#define CLASS_AOAC_RSVD_PAGE 0X04
#define CLASS_AOAC_RSVD_PAGE2 0X04
#define CLASS_D0_SCAN_OFFLOAD_INFO 0X04
#define CLASS_CHANNEL_SWITCH_OFFLOAD 0X04
#define CLASS_AOAC_RSVD_PAGE3 0X04
#define ORIGINAL_H2C_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define ORIGINAL_H2C_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define ORIGINAL_H2C_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define ORIGINAL_H2C_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define ORIGINAL_H2C_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define ORIGINAL_H2C_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define H2C2H_LB_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define H2C2H_LB_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define H2C2H_LB_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define H2C2H_LB_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define H2C2H_LB_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define H2C2H_LB_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define H2C2H_LB_GET_SEQ(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define H2C2H_LB_SET_SEQ(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define H2C2H_LB_SET_SEQ_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define H2C2H_LB_GET_PAYLOAD1(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 16)
#define H2C2H_LB_SET_PAYLOAD1(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 16, __Value)
#define H2C2H_LB_SET_PAYLOAD1_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 16, __Value)
#define H2C2H_LB_GET_PAYLOAD2(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 32)
#define H2C2H_LB_SET_PAYLOAD2(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 32, __Value)
#define H2C2H_LB_SET_PAYLOAD2_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 32, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define D0_SCAN_OFFLOAD_CTRL_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define D0_SCAN_OFFLOAD_CTRL_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_D0_SCAN_FUN_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define D0_SCAN_OFFLOAD_CTRL_SET_D0_SCAN_FUN_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_D0_SCAN_FUN_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_RTD3FUN_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define D0_SCAN_OFFLOAD_CTRL_SET_RTD3FUN_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_RTD3FUN_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_U3_SCAN_FUN_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 10, 1)
#define D0_SCAN_OFFLOAD_CTRL_SET_U3_SCAN_FUN_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 10, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_U3_SCAN_FUN_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 10, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_NLO_FUN_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 11, 1)
#define D0_SCAN_OFFLOAD_CTRL_SET_NLO_FUN_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 11, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_NLO_FUN_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 11, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_IPS_DEPENDENT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 12, 1)
#define D0_SCAN_OFFLOAD_CTRL_SET_IPS_DEPENDENT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 12, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_IPS_DEPENDENT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 12, 1, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_LOC_PROBE_PACKET(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 17)
#define D0_SCAN_OFFLOAD_CTRL_SET_LOC_PROBE_PACKET(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 17, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_LOC_PROBE_PACKET_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 17, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_LOC_SCAN_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define D0_SCAN_OFFLOAD_CTRL_SET_LOC_SCAN_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_LOC_SCAN_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define D0_SCAN_OFFLOAD_CTRL_GET_LOC_SSID_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define D0_SCAN_OFFLOAD_CTRL_SET_LOC_SSID_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define D0_SCAN_OFFLOAD_CTRL_SET_LOC_SSID_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define RSVD_PAGE_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define RSVD_PAGE_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define RSVD_PAGE_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define RSVD_PAGE_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define RSVD_PAGE_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define RSVD_PAGE_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define RSVD_PAGE_GET_LOC_PROBE_RSP(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define RSVD_PAGE_SET_LOC_PROBE_RSP(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define RSVD_PAGE_SET_LOC_PROBE_RSP_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define RSVD_PAGE_GET_LOC_PS_POLL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define RSVD_PAGE_SET_LOC_PS_POLL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define RSVD_PAGE_SET_LOC_PS_POLL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define RSVD_PAGE_GET_LOC_NULL_DATA(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define RSVD_PAGE_SET_LOC_NULL_DATA(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define RSVD_PAGE_SET_LOC_NULL_DATA_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define RSVD_PAGE_GET_LOC_QOS_NULL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define RSVD_PAGE_SET_LOC_QOS_NULL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define RSVD_PAGE_SET_LOC_QOS_NULL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define RSVD_PAGE_GET_LOC_BT_QOS_NULL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define RSVD_PAGE_SET_LOC_BT_QOS_NULL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define RSVD_PAGE_SET_LOC_BT_QOS_NULL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define RSVD_PAGE_GET_LOC_CTS2SELF(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 16, 8)
#define RSVD_PAGE_SET_LOC_CTS2SELF(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 16, 8, __Value)
#define RSVD_PAGE_SET_LOC_CTS2SELF_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 16, 8, __Value)
#define RSVD_PAGE_GET_LOC_LTECOEX_QOSNULL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 24, 8)
#define RSVD_PAGE_SET_LOC_LTECOEX_QOSNULL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 24, 8, __Value)
#define RSVD_PAGE_SET_LOC_LTECOEX_QOSNULL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 24, 8, __Value)
#define MEDIA_STATUS_RPT_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define MEDIA_STATUS_RPT_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define MEDIA_STATUS_RPT_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define MEDIA_STATUS_RPT_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define MEDIA_STATUS_RPT_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define MEDIA_STATUS_RPT_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define MEDIA_STATUS_RPT_GET_OP_MODE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define MEDIA_STATUS_RPT_SET_OP_MODE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define MEDIA_STATUS_RPT_SET_OP_MODE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define MEDIA_STATUS_RPT_GET_MACID_IN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define MEDIA_STATUS_RPT_SET_MACID_IN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define MEDIA_STATUS_RPT_SET_MACID_IN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define MEDIA_STATUS_RPT_GET_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define MEDIA_STATUS_RPT_SET_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define MEDIA_STATUS_RPT_SET_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define MEDIA_STATUS_RPT_GET_MACID_END(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define MEDIA_STATUS_RPT_SET_MACID_END(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define MEDIA_STATUS_RPT_SET_MACID_END_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define KEEP_ALIVE_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define KEEP_ALIVE_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define KEEP_ALIVE_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define KEEP_ALIVE_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define KEEP_ALIVE_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define KEEP_ALIVE_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define KEEP_ALIVE_GET_ENABLE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define KEEP_ALIVE_SET_ENABLE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define KEEP_ALIVE_SET_ENABLE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define KEEP_ALIVE_GET_ADOPT_USER_SETTING(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define KEEP_ALIVE_SET_ADOPT_USER_SETTING(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define KEEP_ALIVE_SET_ADOPT_USER_SETTING_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define KEEP_ALIVE_GET_PKT_TYPE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 10, 1)
#define KEEP_ALIVE_SET_PKT_TYPE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 10, 1, __Value)
#define KEEP_ALIVE_SET_PKT_TYPE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 10, 1, __Value)
#define KEEP_ALIVE_GET_KEEP_ALIVE_CHECK_PERIOD(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define KEEP_ALIVE_SET_KEEP_ALIVE_CHECK_PERIOD(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define KEEP_ALIVE_SET_KEEP_ALIVE_CHECK_PERIOD_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define DISCONNECT_DECISION_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define DISCONNECT_DECISION_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define DISCONNECT_DECISION_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define DISCONNECT_DECISION_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define DISCONNECT_DECISION_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define DISCONNECT_DECISION_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define DISCONNECT_DECISION_GET_ENABLE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define DISCONNECT_DECISION_SET_ENABLE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define DISCONNECT_DECISION_SET_ENABLE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define DISCONNECT_DECISION_GET_ADOPT_USER_SETTING(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define DISCONNECT_DECISION_SET_ADOPT_USER_SETTING(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define DISCONNECT_DECISION_SET_ADOPT_USER_SETTING_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define DISCONNECT_DECISION_GET_TRY_OK_BCN_FAIL_COUNT_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 10, 1)
#define DISCONNECT_DECISION_SET_TRY_OK_BCN_FAIL_COUNT_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 10, 1, __Value)
#define DISCONNECT_DECISION_SET_TRY_OK_BCN_FAIL_COUNT_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 10, 1, __Value)
#define DISCONNECT_DECISION_GET_DISCONNECT_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 11, 1)
#define DISCONNECT_DECISION_SET_DISCONNECT_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 11, 1, __Value)
#define DISCONNECT_DECISION_SET_DISCONNECT_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 11, 1, __Value)
#define DISCONNECT_DECISION_GET_DISCON_DECISION_CHECK_PERIOD(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define DISCONNECT_DECISION_SET_DISCON_DECISION_CHECK_PERIOD(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define DISCONNECT_DECISION_SET_DISCON_DECISION_CHECK_PERIOD_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define DISCONNECT_DECISION_GET_TRY_PKT_NUM(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define DISCONNECT_DECISION_SET_TRY_PKT_NUM(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define DISCONNECT_DECISION_SET_TRY_PKT_NUM_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define DISCONNECT_DECISION_GET_TRY_OK_BCN_FAIL_COUNT_LIMIT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define DISCONNECT_DECISION_SET_TRY_OK_BCN_FAIL_COUNT_LIMIT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define DISCONNECT_DECISION_SET_TRY_OK_BCN_FAIL_COUNT_LIMIT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define AP_OFFLOAD_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define AP_OFFLOAD_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AP_OFFLOAD_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AP_OFFLOAD_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define AP_OFFLOAD_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AP_OFFLOAD_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AP_OFFLOAD_GET_ON(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define AP_OFFLOAD_SET_ON(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define AP_OFFLOAD_SET_ON_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define AP_OFFLOAD_GET_CFG_MIFI_PLATFORM(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define AP_OFFLOAD_SET_CFG_MIFI_PLATFORM(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define AP_OFFLOAD_SET_CFG_MIFI_PLATFORM_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define AP_OFFLOAD_GET_LINKED(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 10, 1)
#define AP_OFFLOAD_SET_LINKED(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 10, 1, __Value)
#define AP_OFFLOAD_SET_LINKED_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 10, 1, __Value)
#define AP_OFFLOAD_GET_EN_AUTO_WAKE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 11, 1)
#define AP_OFFLOAD_SET_EN_AUTO_WAKE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 11, 1, __Value)
#define AP_OFFLOAD_SET_EN_AUTO_WAKE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 11, 1, __Value)
#define AP_OFFLOAD_GET_WAKE_FLAG(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 12, 1)
#define AP_OFFLOAD_SET_WAKE_FLAG(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 12, 1, __Value)
#define AP_OFFLOAD_SET_WAKE_FLAG_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 12, 1, __Value)
#define AP_OFFLOAD_GET_HIDDEN_ROOT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 1)
#define AP_OFFLOAD_SET_HIDDEN_ROOT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 1, __Value)
#define AP_OFFLOAD_SET_HIDDEN_ROOT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 1, __Value)
#define AP_OFFLOAD_GET_HIDDEN_VAP1(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 17, 1)
#define AP_OFFLOAD_SET_HIDDEN_VAP1(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 17, 1, __Value)
#define AP_OFFLOAD_SET_HIDDEN_VAP1_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 17, 1, __Value)
#define AP_OFFLOAD_GET_HIDDEN_VAP2(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 18, 1)
#define AP_OFFLOAD_SET_HIDDEN_VAP2(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 18, 1, __Value)
#define AP_OFFLOAD_SET_HIDDEN_VAP2_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 18, 1, __Value)
#define AP_OFFLOAD_GET_HIDDEN_VAP3(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 19, 1)
#define AP_OFFLOAD_SET_HIDDEN_VAP3(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 19, 1, __Value)
#define AP_OFFLOAD_SET_HIDDEN_VAP3_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 19, 1, __Value)
#define AP_OFFLOAD_GET_HIDDEN_VAP4(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 20, 1)
#define AP_OFFLOAD_SET_HIDDEN_VAP4(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 20, 1, __Value)
#define AP_OFFLOAD_SET_HIDDEN_VAP4_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 20, 1, __Value)
#define AP_OFFLOAD_GET_DENYANY_ROOT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 1)
#define AP_OFFLOAD_SET_DENYANY_ROOT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 1, __Value)
#define AP_OFFLOAD_SET_DENYANY_ROOT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 1, __Value)
#define AP_OFFLOAD_GET_DENYANY_VAP1(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 25, 1)
#define AP_OFFLOAD_SET_DENYANY_VAP1(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 25, 1, __Value)
#define AP_OFFLOAD_SET_DENYANY_VAP1_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 25, 1, __Value)
#define AP_OFFLOAD_GET_DENYANY_VAP2(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 26, 1)
#define AP_OFFLOAD_SET_DENYANY_VAP2(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 26, 1, __Value)
#define AP_OFFLOAD_SET_DENYANY_VAP2_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 26, 1, __Value)
#define AP_OFFLOAD_GET_DENYANY_VAP3(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 27, 1)
#define AP_OFFLOAD_SET_DENYANY_VAP3(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 27, 1, __Value)
#define AP_OFFLOAD_SET_DENYANY_VAP3_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 27, 1, __Value)
#define AP_OFFLOAD_GET_DENYANY_VAP4(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 28, 1)
#define AP_OFFLOAD_SET_DENYANY_VAP4(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 28, 1, __Value)
#define AP_OFFLOAD_SET_DENYANY_VAP4_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 28, 1, __Value)
#define AP_OFFLOAD_GET_WAIT_TBTT_CNT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define AP_OFFLOAD_SET_WAIT_TBTT_CNT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define AP_OFFLOAD_SET_WAIT_TBTT_CNT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define AP_OFFLOAD_GET_WAKE_TIMEOUT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define AP_OFFLOAD_SET_WAKE_TIMEOUT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define AP_OFFLOAD_SET_WAKE_TIMEOUT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define AP_OFFLOAD_GET_LEN_IV_PAIR(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 16, 8)
#define AP_OFFLOAD_SET_LEN_IV_PAIR(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 16, 8, __Value)
#define AP_OFFLOAD_SET_LEN_IV_PAIR_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 16, 8, __Value)
#define AP_OFFLOAD_GET_LEN_IV_GRP(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 24, 8)
#define AP_OFFLOAD_SET_LEN_IV_GRP(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 24, 8, __Value)
#define AP_OFFLOAD_SET_LEN_IV_GRP_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 24, 8, __Value)
#define BCN_RSVDPAGE_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define BCN_RSVDPAGE_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define BCN_RSVDPAGE_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define BCN_RSVDPAGE_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define BCN_RSVDPAGE_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define BCN_RSVDPAGE_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define BCN_RSVDPAGE_GET_LOC_ROOT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define BCN_RSVDPAGE_SET_LOC_ROOT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define BCN_RSVDPAGE_SET_LOC_ROOT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define BCN_RSVDPAGE_GET_LOC_VAP1(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define BCN_RSVDPAGE_SET_LOC_VAP1(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define BCN_RSVDPAGE_SET_LOC_VAP1_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define BCN_RSVDPAGE_GET_LOC_VAP2(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define BCN_RSVDPAGE_SET_LOC_VAP2(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define BCN_RSVDPAGE_SET_LOC_VAP2_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define BCN_RSVDPAGE_GET_LOC_VAP3(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define BCN_RSVDPAGE_SET_LOC_VAP3(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define BCN_RSVDPAGE_SET_LOC_VAP3_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define BCN_RSVDPAGE_GET_LOC_VAP4(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define BCN_RSVDPAGE_SET_LOC_VAP4(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define BCN_RSVDPAGE_SET_LOC_VAP4_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define PROBE_RSP_RSVDPAGE_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define PROBE_RSP_RSVDPAGE_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PROBE_RSP_RSVDPAGE_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PROBE_RSP_RSVDPAGE_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define PROBE_RSP_RSVDPAGE_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PROBE_RSP_RSVDPAGE_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PROBE_RSP_RSVDPAGE_GET_LOC_ROOT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define PROBE_RSP_RSVDPAGE_SET_LOC_ROOT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define PROBE_RSP_RSVDPAGE_SET_LOC_ROOT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define PROBE_RSP_RSVDPAGE_GET_LOC_VAP1(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define PROBE_RSP_RSVDPAGE_SET_LOC_VAP1(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define PROBE_RSP_RSVDPAGE_SET_LOC_VAP1_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define PROBE_RSP_RSVDPAGE_GET_LOC_VAP2(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define PROBE_RSP_RSVDPAGE_SET_LOC_VAP2(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define PROBE_RSP_RSVDPAGE_SET_LOC_VAP2_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define PROBE_RSP_RSVDPAGE_GET_LOC_VAP3(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define PROBE_RSP_RSVDPAGE_SET_LOC_VAP3(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define PROBE_RSP_RSVDPAGE_SET_LOC_VAP3_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define PROBE_RSP_RSVDPAGE_GET_LOC_VAP4(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define PROBE_RSP_RSVDPAGE_SET_LOC_VAP4(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define PROBE_RSP_RSVDPAGE_SET_LOC_VAP4_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define SET_PWR_MODE_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define SET_PWR_MODE_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define SET_PWR_MODE_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define SET_PWR_MODE_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define SET_PWR_MODE_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define SET_PWR_MODE_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define SET_PWR_MODE_GET_MODE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 7)
#define SET_PWR_MODE_SET_MODE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 7, __Value)
#define SET_PWR_MODE_SET_MODE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 7, __Value)
#define SET_PWR_MODE_GET_CLK_REQUEST(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 15, 1)
#define SET_PWR_MODE_SET_CLK_REQUEST(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 15, 1, __Value)
#define SET_PWR_MODE_SET_CLK_REQUEST_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 15, 1, __Value)
#define SET_PWR_MODE_GET_RLBM(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 4)
#define SET_PWR_MODE_SET_RLBM(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 4, __Value)
#define SET_PWR_MODE_SET_RLBM_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 4, __Value)
#define SET_PWR_MODE_GET_SMART_PS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 20, 4)
#define SET_PWR_MODE_SET_SMART_PS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 20, 4, __Value)
#define SET_PWR_MODE_SET_SMART_PS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 20, 4, __Value)
#define SET_PWR_MODE_GET_AWAKE_INTERVAL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define SET_PWR_MODE_SET_AWAKE_INTERVAL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define SET_PWR_MODE_SET_AWAKE_INTERVAL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define SET_PWR_MODE_GET_B_ALL_QUEUE_UAPSD(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 1)
#define SET_PWR_MODE_SET_B_ALL_QUEUE_UAPSD(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 1, __Value)
#define SET_PWR_MODE_SET_B_ALL_QUEUE_UAPSD_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 1, __Value)
#define SET_PWR_MODE_GET_BCN_EARLY_RPT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 2, 1)
#define SET_PWR_MODE_SET_BCN_EARLY_RPT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 2, 1, __Value)
#define SET_PWR_MODE_SET_BCN_EARLY_RPT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 2, 1, __Value)
#define SET_PWR_MODE_GET_PORT_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 5, 3)
#define SET_PWR_MODE_SET_PORT_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 5, 3, __Value)
#define SET_PWR_MODE_SET_PORT_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 5, 3, __Value)
#define SET_PWR_MODE_GET_PWR_STATE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define SET_PWR_MODE_SET_PWR_STATE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define SET_PWR_MODE_SET_PWR_STATE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define SET_PWR_MODE_GET_LOW_POWER_RX_BCN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 16, 1)
#define SET_PWR_MODE_SET_LOW_POWER_RX_BCN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 16, 1, __Value)
#define SET_PWR_MODE_SET_LOW_POWER_RX_BCN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 16, 1, __Value)
#define SET_PWR_MODE_GET_ANT_AUTO_SWITCH(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 17, 1)
#define SET_PWR_MODE_SET_ANT_AUTO_SWITCH(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 17, 1, __Value)
#define SET_PWR_MODE_SET_ANT_AUTO_SWITCH_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 17, 1, __Value)
#define SET_PWR_MODE_GET_PS_ALLOW_BT_HIGH_PRIORITY(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 18, 1)
#define SET_PWR_MODE_SET_PS_ALLOW_BT_HIGH_PRIORITY(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 18, 1, __Value)
#define SET_PWR_MODE_SET_PS_ALLOW_BT_HIGH_PRIORITY_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 18, 1, __Value)
#define SET_PWR_MODE_GET_PROTECT_BCN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 19, 1)
#define SET_PWR_MODE_SET_PROTECT_BCN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 19, 1, __Value)
#define SET_PWR_MODE_SET_PROTECT_BCN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 19, 1, __Value)
#define SET_PWR_MODE_GET_SILENCE_PERIOD(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 20, 1)
#define SET_PWR_MODE_SET_SILENCE_PERIOD(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 20, 1, __Value)
#define SET_PWR_MODE_SET_SILENCE_PERIOD_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 20, 1, __Value)
#define SET_PWR_MODE_GET_FAST_BT_CONNECT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 21, 1)
#define SET_PWR_MODE_SET_FAST_BT_CONNECT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 21, 1, __Value)
#define SET_PWR_MODE_SET_FAST_BT_CONNECT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 21, 1, __Value)
#define SET_PWR_MODE_GET_TWO_ANTENNA_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 22, 1)
#define SET_PWR_MODE_SET_TWO_ANTENNA_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 22, 1, __Value)
#define SET_PWR_MODE_SET_TWO_ANTENNA_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 22, 1, __Value)
#define SET_PWR_MODE_GET_ADOPT_USER_SETTING(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 24, 1)
#define SET_PWR_MODE_SET_ADOPT_USER_SETTING(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 24, 1, __Value)
#define SET_PWR_MODE_SET_ADOPT_USER_SETTING_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 24, 1, __Value)
#define SET_PWR_MODE_GET_DRV_BCN_EARLY_SHIFT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 25, 3)
#define SET_PWR_MODE_SET_DRV_BCN_EARLY_SHIFT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 25, 3, __Value)
#define SET_PWR_MODE_SET_DRV_BCN_EARLY_SHIFT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 25, 3, __Value)
#define SET_PWR_MODE_GET_DRV_BCN_EARLY_SHIFT2(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 28, 4)
#define SET_PWR_MODE_SET_DRV_BCN_EARLY_SHIFT2(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 28, 4, __Value)
#define SET_PWR_MODE_SET_DRV_BCN_EARLY_SHIFT2_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 28, 4, __Value)
#define PS_TUNING_PARA_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define PS_TUNING_PARA_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PS_TUNING_PARA_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PS_TUNING_PARA_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define PS_TUNING_PARA_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PS_TUNING_PARA_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PS_TUNING_PARA_GET_BCN_TO_LIMIT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 7)
#define PS_TUNING_PARA_SET_BCN_TO_LIMIT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 7, __Value)
#define PS_TUNING_PARA_SET_BCN_TO_LIMIT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 7, __Value)
#define PS_TUNING_PARA_GET_DTIM_TIME_OUT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 15, 1)
#define PS_TUNING_PARA_SET_DTIM_TIME_OUT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 15, 1, __Value)
#define PS_TUNING_PARA_SET_DTIM_TIME_OUT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 15, 1, __Value)
#define PS_TUNING_PARA_GET_PS_TIME_OUT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 4)
#define PS_TUNING_PARA_SET_PS_TIME_OUT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 4, __Value)
#define PS_TUNING_PARA_SET_PS_TIME_OUT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 4, __Value)
#define PS_TUNING_PARA_GET_ADOPT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define PS_TUNING_PARA_SET_ADOPT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define PS_TUNING_PARA_SET_ADOPT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define PS_TUNING_PARA_II_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define PS_TUNING_PARA_II_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PS_TUNING_PARA_II_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PS_TUNING_PARA_II_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define PS_TUNING_PARA_II_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PS_TUNING_PARA_II_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PS_TUNING_PARA_II_GET_BCN_TO_PERIOD(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 7)
#define PS_TUNING_PARA_II_SET_BCN_TO_PERIOD(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 7, __Value)
#define PS_TUNING_PARA_II_SET_BCN_TO_PERIOD_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 7, __Value)
#define PS_TUNING_PARA_II_GET_ADOPT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 15, 1)
#define PS_TUNING_PARA_II_SET_ADOPT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 15, 1, __Value)
#define PS_TUNING_PARA_II_SET_ADOPT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 15, 1, __Value)
#define PS_TUNING_PARA_II_GET_DRV_EARLY_IVL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define PS_TUNING_PARA_II_SET_DRV_EARLY_IVL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define PS_TUNING_PARA_II_SET_DRV_EARLY_IVL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define PS_LPS_PARA_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define PS_LPS_PARA_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PS_LPS_PARA_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PS_LPS_PARA_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define PS_LPS_PARA_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PS_LPS_PARA_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PS_LPS_PARA_GET_LPS_CONTROL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define PS_LPS_PARA_SET_LPS_CONTROL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define PS_LPS_PARA_SET_LPS_CONTROL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define P2P_PS_OFFLOAD_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define P2P_PS_OFFLOAD_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define P2P_PS_OFFLOAD_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define P2P_PS_OFFLOAD_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define P2P_PS_OFFLOAD_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define P2P_PS_OFFLOAD_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define P2P_PS_OFFLOAD_GET_OFFLOAD_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define P2P_PS_OFFLOAD_SET_OFFLOAD_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define P2P_PS_OFFLOAD_SET_OFFLOAD_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define P2P_PS_OFFLOAD_GET_ROLE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define P2P_PS_OFFLOAD_SET_ROLE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define P2P_PS_OFFLOAD_SET_ROLE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define P2P_PS_OFFLOAD_GET_CTWINDOW_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 10, 1)
#define P2P_PS_OFFLOAD_SET_CTWINDOW_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 10, 1, __Value)
#define P2P_PS_OFFLOAD_SET_CTWINDOW_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 10, 1, __Value)
#define P2P_PS_OFFLOAD_GET_NOA0_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 11, 1)
#define P2P_PS_OFFLOAD_SET_NOA0_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 11, 1, __Value)
#define P2P_PS_OFFLOAD_SET_NOA0_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 11, 1, __Value)
#define P2P_PS_OFFLOAD_GET_NOA1_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 12, 1)
#define P2P_PS_OFFLOAD_SET_NOA1_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 12, 1, __Value)
#define P2P_PS_OFFLOAD_SET_NOA1_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 12, 1, __Value)
#define P2P_PS_OFFLOAD_GET_ALL_STA_SLEEP(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 13, 1)
#define P2P_PS_OFFLOAD_SET_ALL_STA_SLEEP(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 13, 1, __Value)
#define P2P_PS_OFFLOAD_SET_ALL_STA_SLEEP_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 13, 1, __Value)
#define P2P_PS_OFFLOAD_GET_DISCOVERY(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 14, 1)
#define P2P_PS_OFFLOAD_SET_DISCOVERY(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 14, 1, __Value)
#define P2P_PS_OFFLOAD_SET_DISCOVERY_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 14, 1, __Value)
#define PS_SCAN_EN_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define PS_SCAN_EN_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PS_SCAN_EN_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define PS_SCAN_EN_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define PS_SCAN_EN_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PS_SCAN_EN_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define PS_SCAN_EN_GET_ENABLE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define PS_SCAN_EN_SET_ENABLE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define PS_SCAN_EN_SET_ENABLE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define SAP_PS_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define SAP_PS_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define SAP_PS_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define SAP_PS_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define SAP_PS_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define SAP_PS_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define SAP_PS_GET_ENABLE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define SAP_PS_SET_ENABLE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define SAP_PS_SET_ENABLE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define SAP_PS_GET_EN_PS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define SAP_PS_SET_EN_PS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define SAP_PS_SET_EN_PS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define SAP_PS_GET_EN_LP_RX(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 10, 1)
#define SAP_PS_SET_EN_LP_RX(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 10, 1, __Value)
#define SAP_PS_SET_EN_LP_RX_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 10, 1, __Value)
#define SAP_PS_GET_MANUAL_32K(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 11, 1)
#define SAP_PS_SET_MANUAL_32K(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 11, 1, __Value)
#define SAP_PS_SET_MANUAL_32K_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 11, 1, __Value)
#define SAP_PS_GET_DURATION(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define SAP_PS_SET_DURATION(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define SAP_PS_SET_DURATION_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define INACTIVE_PS_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define INACTIVE_PS_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define INACTIVE_PS_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define INACTIVE_PS_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define INACTIVE_PS_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define INACTIVE_PS_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define INACTIVE_PS_GET_ENABLE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define INACTIVE_PS_SET_ENABLE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define INACTIVE_PS_SET_ENABLE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define INACTIVE_PS_GET_IGNORE_PS_CONDITION(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define INACTIVE_PS_SET_IGNORE_PS_CONDITION(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define INACTIVE_PS_SET_IGNORE_PS_CONDITION_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define INACTIVE_PS_GET_FREQUENCY(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define INACTIVE_PS_SET_FREQUENCY(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define INACTIVE_PS_SET_FREQUENCY_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define INACTIVE_PS_GET_DURATION(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define INACTIVE_PS_SET_DURATION(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define INACTIVE_PS_SET_DURATION_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define MACID_CFG_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define MACID_CFG_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define MACID_CFG_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define MACID_CFG_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define MACID_CFG_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define MACID_CFG_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define MACID_CFG_GET_MAC_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define MACID_CFG_SET_MAC_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define MACID_CFG_SET_MAC_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define MACID_CFG_GET_RATE_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 5)
#define MACID_CFG_SET_RATE_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 5, __Value)
#define MACID_CFG_SET_RATE_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 5, __Value)
#define MACID_CFG_GET_INIT_RATE_LV(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 21, 2)
#define MACID_CFG_SET_INIT_RATE_LV(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 21, 2, __Value)
#define MACID_CFG_SET_INIT_RATE_LV_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 21, 2, __Value)
#define MACID_CFG_GET_SGI(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 23, 1)
#define MACID_CFG_SET_SGI(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 23, 1, __Value)
#define MACID_CFG_SET_SGI_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 23, 1, __Value)
#define MACID_CFG_GET_BW(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 2)
#define MACID_CFG_SET_BW(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 2, __Value)
#define MACID_CFG_SET_BW_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 2, __Value)
#define MACID_CFG_GET_LDPC_CAP(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 26, 1)
#define MACID_CFG_SET_LDPC_CAP(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 26, 1, __Value)
#define MACID_CFG_SET_LDPC_CAP_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 26, 1, __Value)
#define MACID_CFG_GET_NO_UPDATE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 27, 1)
#define MACID_CFG_SET_NO_UPDATE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 27, 1, __Value)
#define MACID_CFG_SET_NO_UPDATE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 27, 1, __Value)
#define MACID_CFG_GET_WHT_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 28, 2)
#define MACID_CFG_SET_WHT_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 28, 2, __Value)
#define MACID_CFG_SET_WHT_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 28, 2, __Value)
#define MACID_CFG_GET_DISPT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 30, 1)
#define MACID_CFG_SET_DISPT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 30, 1, __Value)
#define MACID_CFG_SET_DISPT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 30, 1, __Value)
#define MACID_CFG_GET_DISRA(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 31, 1)
#define MACID_CFG_SET_DISRA(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 31, 1, __Value)
#define MACID_CFG_SET_DISRA_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 31, 1, __Value)
#define MACID_CFG_GET_RATE_MASK7_0(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define MACID_CFG_SET_RATE_MASK7_0(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define MACID_CFG_SET_RATE_MASK7_0_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define MACID_CFG_GET_RATE_MASK15_8(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define MACID_CFG_SET_RATE_MASK15_8(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define MACID_CFG_SET_RATE_MASK15_8_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define MACID_CFG_GET_RATE_MASK23_16(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 16, 8)
#define MACID_CFG_SET_RATE_MASK23_16(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 16, 8, __Value)
#define MACID_CFG_SET_RATE_MASK23_16_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 16, 8, __Value)
#define MACID_CFG_GET_RATE_MASK31_24(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 24, 8)
#define MACID_CFG_SET_RATE_MASK31_24(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 24, 8, __Value)
#define MACID_CFG_SET_RATE_MASK31_24_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 24, 8, __Value)
#define TXBF_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define TXBF_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define TXBF_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define TXBF_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define TXBF_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define TXBF_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define TXBF_GET_NDPA0_HEAD_PAGE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define TXBF_SET_NDPA0_HEAD_PAGE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define TXBF_SET_NDPA0_HEAD_PAGE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define TXBF_GET_NDPA1_HEAD_PAGE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define TXBF_SET_NDPA1_HEAD_PAGE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define TXBF_SET_NDPA1_HEAD_PAGE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define TXBF_GET_PERIOD_0(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define TXBF_SET_PERIOD_0(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define TXBF_SET_PERIOD_0_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define RSSI_SETTING_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define RSSI_SETTING_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define RSSI_SETTING_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define RSSI_SETTING_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define RSSI_SETTING_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define RSSI_SETTING_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define RSSI_SETTING_GET_MAC_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define RSSI_SETTING_SET_MAC_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define RSSI_SETTING_SET_MAC_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define RSSI_SETTING_GET_RSSI(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 7)
#define RSSI_SETTING_SET_RSSI(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 7, __Value)
#define RSSI_SETTING_SET_RSSI_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 7, __Value)
#define RSSI_SETTING_GET_RA_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define RSSI_SETTING_SET_RA_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define RSSI_SETTING_SET_RA_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define AP_REQ_TXRPT_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define AP_REQ_TXRPT_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AP_REQ_TXRPT_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AP_REQ_TXRPT_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define AP_REQ_TXRPT_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AP_REQ_TXRPT_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AP_REQ_TXRPT_GET_STA1_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define AP_REQ_TXRPT_SET_STA1_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AP_REQ_TXRPT_SET_STA1_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AP_REQ_TXRPT_GET_STA2_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define AP_REQ_TXRPT_SET_STA2_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AP_REQ_TXRPT_SET_STA2_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AP_REQ_TXRPT_GET_RTY_OK_TOTAL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 1)
#define AP_REQ_TXRPT_SET_RTY_OK_TOTAL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 1, __Value)
#define AP_REQ_TXRPT_SET_RTY_OK_TOTAL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 1, __Value)
#define AP_REQ_TXRPT_GET_RTY_CNT_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 25, 1)
#define AP_REQ_TXRPT_SET_RTY_CNT_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 25, 1, __Value)
#define AP_REQ_TXRPT_SET_RTY_CNT_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 25, 1, __Value)
#define INIT_RATE_COLLECTION_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define INIT_RATE_COLLECTION_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define INIT_RATE_COLLECTION_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define INIT_RATE_COLLECTION_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define INIT_RATE_COLLECTION_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define INIT_RATE_COLLECTION_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define INIT_RATE_COLLECTION_GET_STA1_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define INIT_RATE_COLLECTION_SET_STA1_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define INIT_RATE_COLLECTION_SET_STA1_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define INIT_RATE_COLLECTION_GET_STA2_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define INIT_RATE_COLLECTION_SET_STA2_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define INIT_RATE_COLLECTION_SET_STA2_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define INIT_RATE_COLLECTION_GET_STA3_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define INIT_RATE_COLLECTION_SET_STA3_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define INIT_RATE_COLLECTION_SET_STA3_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define INIT_RATE_COLLECTION_GET_STA4_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define INIT_RATE_COLLECTION_SET_STA4_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define INIT_RATE_COLLECTION_SET_STA4_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define INIT_RATE_COLLECTION_GET_STA5_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define INIT_RATE_COLLECTION_SET_STA5_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define INIT_RATE_COLLECTION_SET_STA5_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define INIT_RATE_COLLECTION_GET_STA6_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 16, 8)
#define INIT_RATE_COLLECTION_SET_STA6_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 16, 8, __Value)
#define INIT_RATE_COLLECTION_SET_STA6_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 16, 8, __Value)
#define INIT_RATE_COLLECTION_GET_STA7_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 24, 8)
#define INIT_RATE_COLLECTION_SET_STA7_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 24, 8, __Value)
#define INIT_RATE_COLLECTION_SET_STA7_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 24, 8, __Value)
#define IQK_OFFLOAD_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define IQK_OFFLOAD_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define IQK_OFFLOAD_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define IQK_OFFLOAD_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define IQK_OFFLOAD_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define IQK_OFFLOAD_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define IQK_OFFLOAD_GET_CHANNEL(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define IQK_OFFLOAD_SET_CHANNEL(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define IQK_OFFLOAD_SET_CHANNEL_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define IQK_OFFLOAD_GET_BWBAND(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define IQK_OFFLOAD_SET_BWBAND(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define IQK_OFFLOAD_SET_BWBAND_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define IQK_OFFLOAD_GET_EXTPALNA(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define IQK_OFFLOAD_SET_EXTPALNA(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define IQK_OFFLOAD_SET_EXTPALNA_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define MACID_CFG_3SS_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define MACID_CFG_3SS_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define MACID_CFG_3SS_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define MACID_CFG_3SS_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define MACID_CFG_3SS_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define MACID_CFG_3SS_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define MACID_CFG_3SS_GET_MACID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define MACID_CFG_3SS_SET_MACID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define MACID_CFG_3SS_SET_MACID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define MACID_CFG_3SS_GET_RATE_MASK_39_32(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define MACID_CFG_3SS_SET_RATE_MASK_39_32(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define MACID_CFG_3SS_SET_RATE_MASK_39_32_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define MACID_CFG_3SS_GET_RATE_MASK_47_40(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define MACID_CFG_3SS_SET_RATE_MASK_47_40(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define MACID_CFG_3SS_SET_RATE_MASK_47_40_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define RA_PARA_ADJUST_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define RA_PARA_ADJUST_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define RA_PARA_ADJUST_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define RA_PARA_ADJUST_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define RA_PARA_ADJUST_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define RA_PARA_ADJUST_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define RA_PARA_ADJUST_GET_MAC_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define RA_PARA_ADJUST_SET_MAC_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define RA_PARA_ADJUST_SET_MAC_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define RA_PARA_ADJUST_GET_PARAMETER_INDEX(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define RA_PARA_ADJUST_SET_PARAMETER_INDEX(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define RA_PARA_ADJUST_SET_PARAMETER_INDEX_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define RA_PARA_ADJUST_GET_RATE_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define RA_PARA_ADJUST_SET_RATE_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define RA_PARA_ADJUST_SET_RATE_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define RA_PARA_ADJUST_GET_VALUE_BYTE0(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define RA_PARA_ADJUST_SET_VALUE_BYTE0(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define RA_PARA_ADJUST_SET_VALUE_BYTE0_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define RA_PARA_ADJUST_GET_VALUE_BYTE1(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define RA_PARA_ADJUST_SET_VALUE_BYTE1(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define RA_PARA_ADJUST_SET_VALUE_BYTE1_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define RA_PARA_ADJUST_GET_ASK_FW_FOR_FW_PARA(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 16, 8)
#define RA_PARA_ADJUST_SET_ASK_FW_FOR_FW_PARA(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 16, 8, __Value)
#define RA_PARA_ADJUST_SET_ASK_FW_FOR_FW_PARA_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 16, 8, __Value)
#define WWLAN_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define WWLAN_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define WWLAN_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define WWLAN_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define WWLAN_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define WWLAN_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define WWLAN_GET_FUNC_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define WWLAN_SET_FUNC_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define WWLAN_SET_FUNC_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define WWLAN_GET_PATTERM_MAT_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define WWLAN_SET_PATTERM_MAT_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define WWLAN_SET_PATTERM_MAT_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define WWLAN_GET_MAGIC_PKT_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 10, 1)
#define WWLAN_SET_MAGIC_PKT_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 10, 1, __Value)
#define WWLAN_SET_MAGIC_PKT_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 10, 1, __Value)
#define WWLAN_GET_UNICAST_WAKEUP_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 11, 1)
#define WWLAN_SET_UNICAST_WAKEUP_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 11, 1, __Value)
#define WWLAN_SET_UNICAST_WAKEUP_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 11, 1, __Value)
#define WWLAN_GET_ALL_PKT_DROP(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 12, 1)
#define WWLAN_SET_ALL_PKT_DROP(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 12, 1, __Value)
#define WWLAN_SET_ALL_PKT_DROP_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 12, 1, __Value)
#define WWLAN_GET_GPIO_ACTIVE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 13, 1)
#define WWLAN_SET_GPIO_ACTIVE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 13, 1, __Value)
#define WWLAN_SET_GPIO_ACTIVE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 13, 1, __Value)
#define WWLAN_GET_REKEY_WAKEUP_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 14, 1)
#define WWLAN_SET_REKEY_WAKEUP_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 14, 1, __Value)
#define WWLAN_SET_REKEY_WAKEUP_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 14, 1, __Value)
#define WWLAN_GET_DEAUTH_WAKEUP_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 15, 1)
#define WWLAN_SET_DEAUTH_WAKEUP_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 15, 1, __Value)
#define WWLAN_SET_DEAUTH_WAKEUP_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 15, 1, __Value)
#define WWLAN_GET_GPIO_NUM(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 7)
#define WWLAN_SET_GPIO_NUM(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 7, __Value)
#define WWLAN_SET_GPIO_NUM_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 7, __Value)
#define WWLAN_GET_DATAPIN_WAKEUP_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 23, 1)
#define WWLAN_SET_DATAPIN_WAKEUP_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 23, 1, __Value)
#define WWLAN_SET_DATAPIN_WAKEUP_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 23, 1, __Value)
#define WWLAN_GET_GPIO_DURATION(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define WWLAN_SET_GPIO_DURATION(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define WWLAN_SET_GPIO_DURATION_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define WWLAN_GET_GPIO_PLUS_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 1)
#define WWLAN_SET_GPIO_PLUS_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 1, __Value)
#define WWLAN_SET_GPIO_PLUS_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 1, __Value)
#define WWLAN_GET_GPIO_PULSE_COUNT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 1, 7)
#define WWLAN_SET_GPIO_PULSE_COUNT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 1, 7, __Value)
#define WWLAN_SET_GPIO_PULSE_COUNT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 1, 7, __Value)
#define WWLAN_GET_DISABLE_UPHY(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 1)
#define WWLAN_SET_DISABLE_UPHY(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 1, __Value)
#define WWLAN_SET_DISABLE_UPHY_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 1, __Value)
#define WWLAN_GET_HST2DEV_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 9, 1)
#define WWLAN_SET_HST2DEV_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 9, 1, __Value)
#define WWLAN_SET_HST2DEV_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 9, 1, __Value)
#define WWLAN_GET_GPIO_DURATION_MS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 10, 1)
#define WWLAN_SET_GPIO_DURATION_MS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 10, 1, __Value)
#define WWLAN_SET_GPIO_DURATION_MS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 10, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define REMOTE_WAKE_CTRL_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define REMOTE_WAKE_CTRL_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define REMOTE_WAKE_CTRL_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define REMOTE_WAKE_CTRL_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define REMOTE_WAKE_CTRL_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define REMOTE_WAKE_CTRL_GET_REMOTE_WAKE_CTRL_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 1)
#define REMOTE_WAKE_CTRL_SET_REMOTE_WAKE_CTRL_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_REMOTE_WAKE_CTRL_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_ARP_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 9, 1)
#define REMOTE_WAKE_CTRL_SET_ARP_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 9, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_ARP_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 9, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_NDP_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 10, 1)
#define REMOTE_WAKE_CTRL_SET_NDP_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 10, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_NDP_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 10, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_GTK_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 11, 1)
#define REMOTE_WAKE_CTRL_SET_GTK_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 11, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_GTK_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 11, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_NLO_OFFLOAD_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 12, 1)
#define REMOTE_WAKE_CTRL_SET_NLO_OFFLOAD_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 12, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_NLO_OFFLOAD_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 12, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_REAL_WOW_V1_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 13, 1)
#define REMOTE_WAKE_CTRL_SET_REAL_WOW_V1_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 13, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_REAL_WOW_V1_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 13, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_REAL_WOW_V2_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 14, 1)
#define REMOTE_WAKE_CTRL_SET_REAL_WOW_V2_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 14, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_REAL_WOW_V2_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 14, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_FW_UNICAST(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 15, 1)
#define REMOTE_WAKE_CTRL_SET_FW_UNICAST(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 15, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_FW_UNICAST_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 15, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_P2P_OFFLOAD_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 1)
#define REMOTE_WAKE_CTRL_SET_P2P_OFFLOAD_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_P2P_OFFLOAD_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_RUNTIME_PM_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 17, 1)
#define REMOTE_WAKE_CTRL_SET_RUNTIME_PM_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 17, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_RUNTIME_PM_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 17, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_NET_BIOS_DROP_EN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 18, 1)
#define REMOTE_WAKE_CTRL_SET_NET_BIOS_DROP_EN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 18, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_NET_BIOS_DROP_EN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 18, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_ARP_ACTION(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 1)
#define REMOTE_WAKE_CTRL_SET_ARP_ACTION(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_ARP_ACTION_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_FW_PARSING_UNTIL_WAKEUP(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 28, 1)
#define REMOTE_WAKE_CTRL_SET_FW_PARSING_UNTIL_WAKEUP(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 28, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_FW_PARSING_UNTIL_WAKEUP_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 28, 1, __Value)
#define REMOTE_WAKE_CTRL_GET_FW_PARSING_AFTER_WAKEUP(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 29, 1)
#define REMOTE_WAKE_CTRL_SET_FW_PARSING_AFTER_WAKEUP(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 29, 1, __Value)
#define REMOTE_WAKE_CTRL_SET_FW_PARSING_AFTER_WAKEUP_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 29, 1, __Value)
#define AOAC_GLOBAL_INFO_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define AOAC_GLOBAL_INFO_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AOAC_GLOBAL_INFO_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AOAC_GLOBAL_INFO_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define AOAC_GLOBAL_INFO_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AOAC_GLOBAL_INFO_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AOAC_GLOBAL_INFO_GET_PAIR_WISE_ENC_ALG(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define AOAC_GLOBAL_INFO_SET_PAIR_WISE_ENC_ALG(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AOAC_GLOBAL_INFO_SET_PAIR_WISE_ENC_ALG_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AOAC_GLOBAL_INFO_GET_GROUP_ENC_ALG(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define AOAC_GLOBAL_INFO_SET_GROUP_ENC_ALG(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AOAC_GLOBAL_INFO_SET_GROUP_ENC_ALG_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AOAC_RSVD_PAGE_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define AOAC_RSVD_PAGE_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AOAC_RSVD_PAGE_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AOAC_RSVD_PAGE_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define AOAC_RSVD_PAGE_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AOAC_RSVD_PAGE_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AOAC_RSVD_PAGE_GET_LOC_REMOTE_CTRL_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define AOAC_RSVD_PAGE_SET_LOC_REMOTE_CTRL_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AOAC_RSVD_PAGE_SET_LOC_REMOTE_CTRL_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AOAC_RSVD_PAGE_GET_LOC_ARP_RESPONSE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define AOAC_RSVD_PAGE_SET_LOC_ARP_RESPONSE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AOAC_RSVD_PAGE_SET_LOC_ARP_RESPONSE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AOAC_RSVD_PAGE_GET_LOC_NEIGHBOR_ADVERTISEMENT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define AOAC_RSVD_PAGE_SET_LOC_NEIGHBOR_ADVERTISEMENT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define AOAC_RSVD_PAGE_SET_LOC_NEIGHBOR_ADVERTISEMENT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define AOAC_RSVD_PAGE_GET_LOC_GTK_RSP(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define AOAC_RSVD_PAGE_SET_LOC_GTK_RSP(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define AOAC_RSVD_PAGE_SET_LOC_GTK_RSP_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define AOAC_RSVD_PAGE_GET_LOC_GTK_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define AOAC_RSVD_PAGE_SET_LOC_GTK_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define AOAC_RSVD_PAGE_SET_LOC_GTK_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define AOAC_RSVD_PAGE_GET_LOC_GTK_EXT_MEM(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 16, 8)
#define AOAC_RSVD_PAGE_SET_LOC_GTK_EXT_MEM(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 16, 8, __Value)
#define AOAC_RSVD_PAGE_SET_LOC_GTK_EXT_MEM_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 16, 8, __Value)
#define AOAC_RSVD_PAGE_GET_LOC_NDP_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 24, 8)
#define AOAC_RSVD_PAGE_SET_LOC_NDP_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 24, 8, __Value)
#define AOAC_RSVD_PAGE_SET_LOC_NDP_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 24, 8, __Value)
#define AOAC_RSVD_PAGE2_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define AOAC_RSVD_PAGE2_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AOAC_RSVD_PAGE2_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AOAC_RSVD_PAGE2_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define AOAC_RSVD_PAGE2_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AOAC_RSVD_PAGE2_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AOAC_RSVD_PAGE2_GET_LOC_ROUTER_SOLICATION(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define AOAC_RSVD_PAGE2_SET_LOC_ROUTER_SOLICATION(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AOAC_RSVD_PAGE2_SET_LOC_ROUTER_SOLICATION_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AOAC_RSVD_PAGE2_GET_LOC_BUBBLE_PACKET(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define AOAC_RSVD_PAGE2_SET_LOC_BUBBLE_PACKET(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AOAC_RSVD_PAGE2_SET_LOC_BUBBLE_PACKET_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AOAC_RSVD_PAGE2_GET_LOC_TEREDO_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define AOAC_RSVD_PAGE2_SET_LOC_TEREDO_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define AOAC_RSVD_PAGE2_SET_LOC_TEREDO_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define AOAC_RSVD_PAGE2_GET_LOC_REALWOW_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 0, 8)
#define AOAC_RSVD_PAGE2_SET_LOC_REALWOW_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 0, 8, __Value)
#define AOAC_RSVD_PAGE2_SET_LOC_REALWOW_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 0, 8, __Value)
#define AOAC_RSVD_PAGE2_GET_LOC_KEEP_ALIVE_PKT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 8, 8)
#define AOAC_RSVD_PAGE2_SET_LOC_KEEP_ALIVE_PKT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 8, 8, __Value)
#define AOAC_RSVD_PAGE2_SET_LOC_KEEP_ALIVE_PKT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 8, 8, __Value)
#define AOAC_RSVD_PAGE2_GET_LOC_ACK_PATTERN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 16, 8)
#define AOAC_RSVD_PAGE2_SET_LOC_ACK_PATTERN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 16, 8, __Value)
#define AOAC_RSVD_PAGE2_SET_LOC_ACK_PATTERN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 16, 8, __Value)
#define AOAC_RSVD_PAGE2_GET_LOC_WAKEUP_PATTERN(__pH2C)    GET_H2C_FIELD(__pH2C + 0X04, 24, 8)
#define AOAC_RSVD_PAGE2_SET_LOC_WAKEUP_PATTERN(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X04, 24, 8, __Value)
#define AOAC_RSVD_PAGE2_SET_LOC_WAKEUP_PATTERN_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X04, 24, 8, __Value)
#define D0_SCAN_OFFLOAD_INFO_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define D0_SCAN_OFFLOAD_INFO_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define D0_SCAN_OFFLOAD_INFO_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define D0_SCAN_OFFLOAD_INFO_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define D0_SCAN_OFFLOAD_INFO_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define D0_SCAN_OFFLOAD_INFO_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define D0_SCAN_OFFLOAD_INFO_GET_LOC_CHANNEL_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define D0_SCAN_OFFLOAD_INFO_SET_LOC_CHANNEL_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define D0_SCAN_OFFLOAD_INFO_SET_LOC_CHANNEL_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define CHANNEL_SWITCH_OFFLOAD_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define CHANNEL_SWITCH_OFFLOAD_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define CHANNEL_SWITCH_OFFLOAD_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define CHANNEL_SWITCH_OFFLOAD_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define CHANNEL_SWITCH_OFFLOAD_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define CHANNEL_SWITCH_OFFLOAD_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define CHANNEL_SWITCH_OFFLOAD_GET_CHANNEL_NUM(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define CHANNEL_SWITCH_OFFLOAD_SET_CHANNEL_NUM(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define CHANNEL_SWITCH_OFFLOAD_SET_CHANNEL_NUM_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define CHANNEL_SWITCH_OFFLOAD_GET_EN_RFE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define CHANNEL_SWITCH_OFFLOAD_SET_EN_RFE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define CHANNEL_SWITCH_OFFLOAD_SET_EN_RFE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#define CHANNEL_SWITCH_OFFLOAD_GET_RFE_TYPE(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 24, 8)
#define CHANNEL_SWITCH_OFFLOAD_SET_RFE_TYPE(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 24, 8, __Value)
#define CHANNEL_SWITCH_OFFLOAD_SET_RFE_TYPE_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 24, 8, __Value)
#define AOAC_RSVD_PAGE3_GET_CMD_ID(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 0, 5)
#define AOAC_RSVD_PAGE3_SET_CMD_ID(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AOAC_RSVD_PAGE3_SET_CMD_ID_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 0, 5, __Value)
#define AOAC_RSVD_PAGE3_GET_CLASS(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 5, 3)
#define AOAC_RSVD_PAGE3_SET_CLASS(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AOAC_RSVD_PAGE3_SET_CLASS_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 5, 3, __Value)
#define AOAC_RSVD_PAGE3_GET_LOC_NLO_INFO(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 8, 8)
#define AOAC_RSVD_PAGE3_SET_LOC_NLO_INFO(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AOAC_RSVD_PAGE3_SET_LOC_NLO_INFO_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 8, 8, __Value)
#define AOAC_RSVD_PAGE3_GET_LOC_AOAC_REPORT(__pH2C)    GET_H2C_FIELD(__pH2C + 0X00, 16, 8)
#define AOAC_RSVD_PAGE3_SET_LOC_AOAC_REPORT(__pH2C, __Value)    SET_H2C_FIELD_CLR(__pH2C + 0X00, 16, 8, __Value)
#define AOAC_RSVD_PAGE3_SET_LOC_AOAC_REPORT_NO_CLR(__pH2C, __Value)    SET_H2C_FIELD_NO_CLR(__pH2C + 0X00, 16, 8, __Value)
#endif
